/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.Status;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class StatusResponse
implements JsonpSerializable {
    private final List<Status> snapshots;
    public static final JsonpDeserializer<StatusResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StatusResponse::setupStatusResponseDeserializer, Builder::build);

    public StatusResponse(Builder builder) {
        this.snapshots = ModelTypeHelper.unmodifiableNonNull(builder.snapshots, "snapshots");
    }

    public StatusResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Status> snapshots() {
        return this.snapshots;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshots");
        generator.writeStartArray();
        for (Status item0 : this.snapshots) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupStatusResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer(Status._DESERIALIZER), "snapshots", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StatusResponse> {
        private List<Status> snapshots;

        public Builder snapshots(List<Status> value) {
            this.snapshots = value;
            return this;
        }

        public Builder snapshots(Status ... value) {
            this.snapshots = Arrays.asList(value);
            return this;
        }

        public Builder addSnapshots(Status value) {
            if (this.snapshots == null) {
                this.snapshots = new ArrayList<Status>();
            }
            this.snapshots.add(value);
            return this;
        }

        public Builder snapshots(Function<Status.Builder, ObjectBuilder<Status>> fn) {
            return this.snapshots(fn.apply(new Status.Builder()).build());
        }

        public Builder addSnapshots(Function<Status.Builder, ObjectBuilder<Status>> fn) {
            return this.addSnapshots(fn.apply(new Status.Builder()).build());
        }

        @Override
        public StatusResponse build() {
            return new StatusResponse(this);
        }
    }
}

