/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FileCountSnapshotStats
implements JsonpSerializable {
    private final int fileCount;
    private final long sizeInBytes;
    public static final JsonpDeserializer<FileCountSnapshotStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileCountSnapshotStats::setupFileCountSnapshotStatsDeserializer, Builder::build);

    public FileCountSnapshotStats(Builder builder) {
        this.fileCount = Objects.requireNonNull(builder.fileCount, "file_count");
        this.sizeInBytes = Objects.requireNonNull(builder.sizeInBytes, "size_in_bytes");
    }

    public FileCountSnapshotStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int fileCount() {
        return this.fileCount;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("file_count");
        generator.write(this.fileCount);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    protected static void setupFileCountSnapshotStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fileCount, JsonpDeserializer.integerDeserializer(), "file_count", new String[0]);
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FileCountSnapshotStats> {
        private Integer fileCount;
        private Long sizeInBytes;

        public Builder fileCount(int value) {
            this.fileCount = value;
            return this;
        }

        public Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        public FileCountSnapshotStats build() {
            return new FileCountSnapshotStats(this);
        }
    }
}

