/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Statistics
implements JsonpSerializable {
    @Nullable
    private final String retentionDeletionTime;
    @Nullable
    private final String retentionDeletionTimeMillis;
    @Nullable
    private final Long retentionFailed;
    @Nullable
    private final Long retentionRuns;
    @Nullable
    private final Long retentionTimedOut;
    @Nullable
    private final String policy;
    @Nullable
    private final Long totalSnapshotsDeleted;
    @Nullable
    private final Long totalSnapshotDeletionFailures;
    @Nullable
    private final Long totalSnapshotsFailed;
    @Nullable
    private final Long totalSnapshotsTaken;
    public static final JsonpDeserializer<Statistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Statistics::setupStatisticsDeserializer, Builder::build);

    public Statistics(Builder builder) {
        this.retentionDeletionTime = builder.retentionDeletionTime;
        this.retentionDeletionTimeMillis = builder.retentionDeletionTimeMillis;
        this.retentionFailed = builder.retentionFailed;
        this.retentionRuns = builder.retentionRuns;
        this.retentionTimedOut = builder.retentionTimedOut;
        this.policy = builder.policy;
        this.totalSnapshotsDeleted = builder.totalSnapshotsDeleted;
        this.totalSnapshotDeletionFailures = builder.totalSnapshotDeletionFailures;
        this.totalSnapshotsFailed = builder.totalSnapshotsFailed;
        this.totalSnapshotsTaken = builder.totalSnapshotsTaken;
    }

    public Statistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String retentionDeletionTime() {
        return this.retentionDeletionTime;
    }

    @Nullable
    public String retentionDeletionTimeMillis() {
        return this.retentionDeletionTimeMillis;
    }

    @Nullable
    public Long retentionFailed() {
        return this.retentionFailed;
    }

    @Nullable
    public Long retentionRuns() {
        return this.retentionRuns;
    }

    @Nullable
    public Long retentionTimedOut() {
        return this.retentionTimedOut;
    }

    @Nullable
    public String policy() {
        return this.policy;
    }

    @Nullable
    public Long totalSnapshotsDeleted() {
        return this.totalSnapshotsDeleted;
    }

    @Nullable
    public Long totalSnapshotDeletionFailures() {
        return this.totalSnapshotDeletionFailures;
    }

    @Nullable
    public Long totalSnapshotsFailed() {
        return this.totalSnapshotsFailed;
    }

    @Nullable
    public Long totalSnapshotsTaken() {
        return this.totalSnapshotsTaken;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.retentionDeletionTime != null) {
            generator.writeKey("retention_deletion_time");
            generator.write(this.retentionDeletionTime);
        }
        if (this.retentionDeletionTimeMillis != null) {
            generator.writeKey("retention_deletion_time_millis");
            generator.write(this.retentionDeletionTimeMillis);
        }
        if (this.retentionFailed != null) {
            generator.writeKey("retention_failed");
            generator.write(this.retentionFailed.longValue());
        }
        if (this.retentionRuns != null) {
            generator.writeKey("retention_runs");
            generator.write(this.retentionRuns.longValue());
        }
        if (this.retentionTimedOut != null) {
            generator.writeKey("retention_timed_out");
            generator.write(this.retentionTimedOut.longValue());
        }
        if (this.policy != null) {
            generator.writeKey("policy");
            generator.write(this.policy);
        }
        if (this.totalSnapshotsDeleted != null) {
            generator.writeKey("total_snapshots_deleted");
            generator.write(this.totalSnapshotsDeleted.longValue());
        }
        if (this.totalSnapshotDeletionFailures != null) {
            generator.writeKey("total_snapshot_deletion_failures");
            generator.write(this.totalSnapshotDeletionFailures.longValue());
        }
        if (this.totalSnapshotsFailed != null) {
            generator.writeKey("total_snapshots_failed");
            generator.write(this.totalSnapshotsFailed.longValue());
        }
        if (this.totalSnapshotsTaken != null) {
            generator.writeKey("total_snapshots_taken");
            generator.write(this.totalSnapshotsTaken.longValue());
        }
    }

    protected static void setupStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::retentionDeletionTime, JsonpDeserializer.stringDeserializer(), "retention_deletion_time", new String[0]);
        op.add(Builder::retentionDeletionTimeMillis, JsonpDeserializer.stringDeserializer(), "retention_deletion_time_millis", new String[0]);
        op.add(Builder::retentionFailed, JsonpDeserializer.longDeserializer(), "retention_failed", new String[0]);
        op.add(Builder::retentionRuns, JsonpDeserializer.longDeserializer(), "retention_runs", new String[0]);
        op.add(Builder::retentionTimedOut, JsonpDeserializer.longDeserializer(), "retention_timed_out", new String[0]);
        op.add(Builder::policy, JsonpDeserializer.stringDeserializer(), "policy", new String[0]);
        op.add(Builder::totalSnapshotsDeleted, JsonpDeserializer.longDeserializer(), "total_snapshots_deleted", "snapshots_deleted");
        op.add(Builder::totalSnapshotDeletionFailures, JsonpDeserializer.longDeserializer(), "total_snapshot_deletion_failures", "snapshot_deletion_failures");
        op.add(Builder::totalSnapshotsFailed, JsonpDeserializer.longDeserializer(), "total_snapshots_failed", "snapshots_failed");
        op.add(Builder::totalSnapshotsTaken, JsonpDeserializer.longDeserializer(), "total_snapshots_taken", "snapshots_taken");
    }

    public static class Builder
    implements ObjectBuilder<Statistics> {
        @Nullable
        private String retentionDeletionTime;
        @Nullable
        private String retentionDeletionTimeMillis;
        @Nullable
        private Long retentionFailed;
        @Nullable
        private Long retentionRuns;
        @Nullable
        private Long retentionTimedOut;
        @Nullable
        private String policy;
        @Nullable
        private Long totalSnapshotsDeleted;
        @Nullable
        private Long totalSnapshotDeletionFailures;
        @Nullable
        private Long totalSnapshotsFailed;
        @Nullable
        private Long totalSnapshotsTaken;

        public Builder retentionDeletionTime(@Nullable String value) {
            this.retentionDeletionTime = value;
            return this;
        }

        public Builder retentionDeletionTimeMillis(@Nullable String value) {
            this.retentionDeletionTimeMillis = value;
            return this;
        }

        public Builder retentionFailed(@Nullable Long value) {
            this.retentionFailed = value;
            return this;
        }

        public Builder retentionRuns(@Nullable Long value) {
            this.retentionRuns = value;
            return this;
        }

        public Builder retentionTimedOut(@Nullable Long value) {
            this.retentionTimedOut = value;
            return this;
        }

        public Builder policy(@Nullable String value) {
            this.policy = value;
            return this;
        }

        public Builder totalSnapshotsDeleted(@Nullable Long value) {
            this.totalSnapshotsDeleted = value;
            return this;
        }

        public Builder totalSnapshotDeletionFailures(@Nullable Long value) {
            this.totalSnapshotDeletionFailures = value;
            return this;
        }

        public Builder totalSnapshotsFailed(@Nullable Long value) {
            this.totalSnapshotsFailed = value;
            return this;
        }

        public Builder totalSnapshotsTaken(@Nullable Long value) {
            this.totalSnapshotsTaken = value;
            return this;
        }

        @Override
        public Statistics build() {
            return new Statistics(this);
        }
    }
}

