/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Retention
implements JsonpSerializable {
    private final String expireAfter;
    private final int maxCount;
    private final int minCount;
    public static final JsonpDeserializer<Retention> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Retention::setupRetentionDeserializer, Builder::build);

    public Retention(Builder builder) {
        this.expireAfter = Objects.requireNonNull(builder.expireAfter, "expire_after");
        this.maxCount = Objects.requireNonNull(builder.maxCount, "max_count");
        this.minCount = Objects.requireNonNull(builder.minCount, "min_count");
    }

    public Retention(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String expireAfter() {
        return this.expireAfter;
    }

    public int maxCount() {
        return this.maxCount;
    }

    public int minCount() {
        return this.minCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expire_after");
        generator.write(this.expireAfter);
        generator.writeKey("max_count");
        generator.write(this.maxCount);
        generator.writeKey("min_count");
        generator.write(this.minCount);
    }

    protected static void setupRetentionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::expireAfter, JsonpDeserializer.stringDeserializer(), "expire_after", new String[0]);
        op.add(Builder::maxCount, JsonpDeserializer.integerDeserializer(), "max_count", new String[0]);
        op.add(Builder::minCount, JsonpDeserializer.integerDeserializer(), "min_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Retention> {
        private String expireAfter;
        private Integer maxCount;
        private Integer minCount;

        public Builder expireAfter(String value) {
            this.expireAfter = value;
            return this;
        }

        public Builder maxCount(int value) {
            this.maxCount = value;
            return this;
        }

        public Builder minCount(int value) {
            this.minCount = value;
            return this;
        }

        @Override
        public Retention build() {
            return new Retention(this);
        }
    }
}

