/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.FieldRule;
import co.elastic.clients.elasticsearch.security.RoleMappingRuleVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class RoleMappingRule
implements TaggedUnion<Object>,
RoleMappingRuleVariant,
JsonpSerializable {
    public static final String ANY = "any";
    public static final String ALL = "all";
    public static final String FIELD = "field";
    public static final String EXCEPT = "except";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<RoleMappingRule> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, RoleMappingRule::setupRoleMappingRuleDeserializer, Builder::build);

    @Override
    public String _variantType() {
        return EXCEPT;
    }

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public RoleMappingRule(RoleMappingRuleVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends RoleMappingRuleVariant> RoleMappingRule(ObjectBuilder<T> builder) {
        this((RoleMappingRuleVariant)builder.build());
    }

    private RoleMappingRule(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public RoleMappingRule(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<RoleMappingRule> any() {
        return (List)TaggedUnionUtils.get(this, ANY);
    }

    public List<RoleMappingRule> all() {
        return (List)TaggedUnionUtils.get(this, ALL);
    }

    public FieldRule field() {
        return (FieldRule)TaggedUnionUtils.get(this, FIELD);
    }

    public RoleMappingRule except() {
        return (RoleMappingRule)TaggedUnionUtils.get(this, EXCEPT);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "any": {
                    generator.writeStartArray();
                    for (RoleMappingRule item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case "all": {
                    generator.writeStartArray();
                    for (RoleMappingRule item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupRoleMappingRuleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::any, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), ANY, new String[0]);
        op.add(Builder::all, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), ALL, new String[0]);
        op.add(Builder::field, FieldRule._DESERIALIZER, FIELD, new String[0]);
        op.add(Builder::except, _DESERIALIZER, EXCEPT, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RoleMappingRule> {
        private String _type;
        private Object _value;

        public Builder any(List<RoleMappingRule> v) {
            this._type = RoleMappingRule.ANY;
            this._value = v;
            return this;
        }

        public Builder all(List<RoleMappingRule> v) {
            this._type = RoleMappingRule.ALL;
            this._value = v;
            return this;
        }

        public Builder field(FieldRule v) {
            this._type = RoleMappingRule.FIELD;
            this._value = v;
            return this;
        }

        public Builder field(Function<FieldRule.Builder, ObjectBuilder<FieldRule>> f) {
            return this.field(f.apply(new FieldRule.Builder()).build());
        }

        public Builder except(RoleMappingRule v) {
            this._type = RoleMappingRule.EXCEPT;
            this._value = v;
            return this;
        }

        public Builder except(Function<Builder, ObjectBuilder<RoleMappingRule>> f) {
            return this.except(f.apply(new Builder()).build());
        }

        @Override
        public RoleMappingRule build() {
            return new RoleMappingRule(this);
        }
    }
}

