/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.RoleMappingRule;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RoleMapping
implements JsonpSerializable {
    private final boolean enabled;
    private final Map<String, JsonData> metadata;
    private final List<String> roles;
    private final RoleMappingRule rules;
    @Nullable
    private final List<JsonValue> roleTemplates;
    public static final JsonpDeserializer<RoleMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleMapping::setupRoleMappingDeserializer, Builder::build);

    public RoleMapping(Builder builder) {
        this.enabled = Objects.requireNonNull(builder.enabled, "enabled");
        this.metadata = ModelTypeHelper.unmodifiableNonNull(builder.metadata, "metadata");
        this.roles = ModelTypeHelper.unmodifiableNonNull(builder.roles, "roles");
        this.rules = Objects.requireNonNull(builder.rules, "rules");
        this.roleTemplates = ModelTypeHelper.unmodifiable(builder.roleTemplates);
    }

    public RoleMapping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public List<String> roles() {
        return this.roles;
    }

    public RoleMappingRule rules() {
        return this.rules;
    }

    @Nullable
    public List<JsonValue> roleTemplates() {
        return this.roleTemplates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enabled");
        generator.write(this.enabled);
        generator.writeKey("metadata");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("roles");
        generator.writeStartArray();
        for (String string : this.roles) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("rules");
        this.rules.serialize(generator, mapper);
        if (this.roleTemplates != null) {
            generator.writeKey("role_templates");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.roleTemplates) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRoleMappingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles", new String[0]);
        op.add(Builder::rules, RoleMappingRule._DESERIALIZER, "rules", new String[0]);
        op.add(Builder::roleTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "role_templates", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RoleMapping> {
        private Boolean enabled;
        private Map<String, JsonData> metadata;
        private List<String> roles;
        private RoleMappingRule rules;
        @Nullable
        private List<JsonValue> roleTemplates;

        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder metadata(Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder roles(List<String> value) {
            this.roles = value;
            return this;
        }

        public Builder roles(String ... value) {
            this.roles = Arrays.asList(value);
            return this;
        }

        public Builder addRoles(String value) {
            if (this.roles == null) {
                this.roles = new ArrayList<String>();
            }
            this.roles.add(value);
            return this;
        }

        public Builder rules(RoleMappingRule value) {
            this.rules = value;
            return this;
        }

        public Builder rules(Function<RoleMappingRule.Builder, ObjectBuilder<RoleMappingRule>> fn) {
            return this.rules(fn.apply(new RoleMappingRule.Builder()).build());
        }

        public Builder roleTemplates(@Nullable List<JsonValue> value) {
            this.roleTemplates = value;
            return this;
        }

        public Builder roleTemplates(JsonValue ... value) {
            this.roleTemplates = Arrays.asList(value);
            return this;
        }

        public Builder addRoleTemplates(JsonValue value) {
            if (this.roleTemplates == null) {
                this.roleTemplates = new ArrayList<JsonValue>();
            }
            this.roleTemplates.add(value);
            return this;
        }

        @Override
        public RoleMapping build() {
            return new RoleMapping(this);
        }
    }
}

