/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.PutPrivilegesResponse;
import co.elastic.clients.elasticsearch.security.put_privileges.Actions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutPrivilegesRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final JsonValue refresh;
    private final Map<String, Map<String, Actions>> privileges;
    public static final JsonpDeserializer<PutPrivilegesRequest> _DESERIALIZER = PutPrivilegesRequest.createPutPrivilegesRequestDeserializer();
    public static final Endpoint<PutPrivilegesRequest, PutPrivilegesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutPrivilegesRequest, PutPrivilegesResponse>(request -> "PUT", request -> "/_security/privilege/", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutPrivilegesResponse._DESERIALIZER);

    public PutPrivilegesRequest(Builder builder) {
        this.refresh = builder.refresh;
        this.privileges = ModelTypeHelper.unmodifiableNonNull(builder.privileges, "_value_body");
    }

    public PutPrivilegesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    public Map<String, Map<String, Actions>> privileges() {
        return this.privileges;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        for (Map.Entry<String, Map<String, Actions>> item0 : this.privileges.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartObject();
            for (Map.Entry<String, Actions> item1 : item0.getValue().entrySet()) {
                generator.writeKey(item1.getKey());
                item1.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<PutPrivilegesRequest> createPutPrivilegesRequestDeserializer() {
        JsonpDeserializer<Map<String, Map<String, Actions>>> valueDeserializer = JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(Actions._DESERIALIZER));
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().privileges((Map)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<PutPrivilegesRequest> {
        @Nullable
        private JsonValue refresh;
        private Map<String, Map<String, Actions>> privileges;

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder privileges(Map<String, Map<String, Actions>> value) {
            this.privileges = value;
            return this;
        }

        public Builder putPrivileges(String key, Map<String, Actions> value) {
            if (this.privileges == null) {
                this.privileges = new HashMap<String, Map<String, Actions>>();
            }
            this.privileges.put(key, value);
            return this;
        }

        @Override
        public PutPrivilegesRequest build() {
            return new PutPrivilegesRequest(this);
        }
    }
}

