/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DeleteUserResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteUserRequest
extends RequestBase {
    private final String username;
    @Nullable
    private final JsonValue refresh;
    public static final Endpoint<DeleteUserRequest, DeleteUserResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteUserRequest, DeleteUserResponse>(request -> "DELETE", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteUserResponse._DESERIALIZER);

    public DeleteUserRequest(Builder builder) {
        this.username = Objects.requireNonNull(builder.username, "username");
        this.refresh = builder.refresh;
    }

    public DeleteUserRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String username() {
        return this.username;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    public static class Builder
    implements ObjectBuilder<DeleteUserRequest> {
        private String username;
        @Nullable
        private JsonValue refresh;

        public Builder username(String value) {
            this.username = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        @Override
        public DeleteUserRequest build() {
            return new DeleteUserRequest(this);
        }
    }
}

