/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ClearApiKeyCacheResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ClearApiKeyCacheRequest
extends RequestBase {
    private final List<String> ids;
    public static final Endpoint<ClearApiKeyCacheRequest, ClearApiKeyCacheResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ClearApiKeyCacheRequest, ClearApiKeyCacheResponse>(request -> "POST", request -> {
        boolean _ids = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/api_key");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.ids.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_clear_cache");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, ClearApiKeyCacheResponse._DESERIALIZER);

    public ClearApiKeyCacheRequest(Builder builder) {
        this.ids = ModelTypeHelper.unmodifiableNonNull(builder.ids, "ids");
    }

    public ClearApiKeyCacheRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> ids() {
        return this.ids;
    }

    public static class Builder
    implements ObjectBuilder<ClearApiKeyCacheRequest> {
        private List<String> ids;

        public Builder ids(List<String> value) {
            this.ids = value;
            return this;
        }

        public Builder ids(String ... value) {
            this.ids = Arrays.asList(value);
            return this;
        }

        public Builder addIds(String value) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            this.ids.add(value);
            return this;
        }

        @Override
        public ClearApiKeyCacheRequest build() {
            return new ClearApiKeyCacheRequest(this);
        }
    }
}

