/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_rollup_index_caps;

import co.elastic.clients.elasticsearch.rollup.get_rollup_index_caps.RollupJobSummary;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class IndexCapabilities
implements JsonpSerializable {
    private final List<RollupJobSummary> rollupJobs;
    public static final JsonpDeserializer<IndexCapabilities> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexCapabilities::setupIndexCapabilitiesDeserializer, Builder::build);

    public IndexCapabilities(Builder builder) {
        this.rollupJobs = ModelTypeHelper.unmodifiableNonNull(builder.rollupJobs, "rollup_jobs");
    }

    public IndexCapabilities(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<RollupJobSummary> rollupJobs() {
        return this.rollupJobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rollup_jobs");
        generator.writeStartArray();
        for (RollupJobSummary item0 : this.rollupJobs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupIndexCapabilitiesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::rollupJobs, JsonpDeserializer.arrayDeserializer(RollupJobSummary._DESERIALIZER), "rollup_jobs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexCapabilities> {
        private List<RollupJobSummary> rollupJobs;

        public Builder rollupJobs(List<RollupJobSummary> value) {
            this.rollupJobs = value;
            return this;
        }

        public Builder rollupJobs(RollupJobSummary ... value) {
            this.rollupJobs = Arrays.asList(value);
            return this;
        }

        public Builder addRollupJobs(RollupJobSummary value) {
            if (this.rollupJobs == null) {
                this.rollupJobs = new ArrayList<RollupJobSummary>();
            }
            this.rollupJobs.add(value);
            return this;
        }

        public Builder rollupJobs(Function<RollupJobSummary.Builder, ObjectBuilder<RollupJobSummary>> fn) {
            return this.rollupJobs(fn.apply(new RollupJobSummary.Builder()).build());
        }

        public Builder addRollupJobs(Function<RollupJobSummary.Builder, ObjectBuilder<RollupJobSummary>> fn) {
            return this.addRollupJobs(fn.apply(new RollupJobSummary.Builder()).build());
        }

        @Override
        public IndexCapabilities build() {
            return new IndexCapabilities(this);
        }
    }
}

