/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_jobs;

import co.elastic.clients.elasticsearch.rollup.get_jobs.IndexingJobState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RollupJobStatus
implements JsonpSerializable {
    @Nullable
    private final Map<String, JsonData> currentPosition;
    private final IndexingJobState jobState;
    @Nullable
    private final Boolean upgradedDocId;
    public static final JsonpDeserializer<RollupJobStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJobStatus::setupRollupJobStatusDeserializer, Builder::build);

    public RollupJobStatus(Builder builder) {
        this.currentPosition = ModelTypeHelper.unmodifiable(builder.currentPosition);
        this.jobState = Objects.requireNonNull(builder.jobState, "job_state");
        this.upgradedDocId = builder.upgradedDocId;
    }

    public RollupJobStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, JsonData> currentPosition() {
        return this.currentPosition;
    }

    public IndexingJobState jobState() {
        return this.jobState;
    }

    @Nullable
    public Boolean upgradedDocId() {
        return this.upgradedDocId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentPosition != null) {
            generator.writeKey("current_position");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.currentPosition.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("job_state");
        this.jobState.serialize(generator, mapper);
        if (this.upgradedDocId != null) {
            generator.writeKey("upgraded_doc_id");
            generator.write(this.upgradedDocId.booleanValue());
        }
    }

    protected static void setupRollupJobStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::currentPosition, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "current_position", new String[0]);
        op.add(Builder::jobState, IndexingJobState._DESERIALIZER, "job_state", new String[0]);
        op.add(Builder::upgradedDocId, JsonpDeserializer.booleanDeserializer(), "upgraded_doc_id", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RollupJobStatus> {
        @Nullable
        private Map<String, JsonData> currentPosition;
        private IndexingJobState jobState;
        @Nullable
        private Boolean upgradedDocId;

        public Builder currentPosition(@Nullable Map<String, JsonData> value) {
            this.currentPosition = value;
            return this;
        }

        public Builder putCurrentPosition(String key, JsonData value) {
            if (this.currentPosition == null) {
                this.currentPosition = new HashMap<String, JsonData>();
            }
            this.currentPosition.put(key, value);
            return this;
        }

        public Builder jobState(IndexingJobState value) {
            this.jobState = value;
            return this;
        }

        public Builder upgradedDocId(@Nullable Boolean value) {
            this.upgradedDocId = value;
            return this;
        }

        @Override
        public RollupJobStatus build() {
            return new RollupJobStatus(this);
        }
    }
}

