/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_jobs;

import co.elastic.clients.elasticsearch.rollup.get_jobs.RollupJobConfiguration;
import co.elastic.clients.elasticsearch.rollup.get_jobs.RollupJobStats;
import co.elastic.clients.elasticsearch.rollup.get_jobs.RollupJobStatus;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RollupJob
implements JsonpSerializable {
    private final RollupJobConfiguration config;
    private final RollupJobStats stats;
    private final RollupJobStatus status;
    public static final JsonpDeserializer<RollupJob> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJob::setupRollupJobDeserializer, Builder::build);

    public RollupJob(Builder builder) {
        this.config = Objects.requireNonNull(builder.config, "config");
        this.stats = Objects.requireNonNull(builder.stats, "stats");
        this.status = Objects.requireNonNull(builder.status, "status");
    }

    public RollupJob(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public RollupJobConfiguration config() {
        return this.config;
    }

    public RollupJobStats stats() {
        return this.stats;
    }

    public RollupJobStatus status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("config");
        this.config.serialize(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
    }

    protected static void setupRollupJobDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::config, RollupJobConfiguration._DESERIALIZER, "config", new String[0]);
        op.add(Builder::stats, RollupJobStats._DESERIALIZER, "stats", new String[0]);
        op.add(Builder::status, RollupJobStatus._DESERIALIZER, "status", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RollupJob> {
        private RollupJobConfiguration config;
        private RollupJobStats stats;
        private RollupJobStatus status;

        public Builder config(RollupJobConfiguration value) {
            this.config = value;
            return this;
        }

        public Builder config(Function<RollupJobConfiguration.Builder, ObjectBuilder<RollupJobConfiguration>> fn) {
            return this.config(fn.apply(new RollupJobConfiguration.Builder()).build());
        }

        public Builder stats(RollupJobStats value) {
            this.stats = value;
            return this;
        }

        public Builder stats(Function<RollupJobStats.Builder, ObjectBuilder<RollupJobStats>> fn) {
            return this.stats(fn.apply(new RollupJobStats.Builder()).build());
        }

        public Builder status(RollupJobStatus value) {
            this.status = value;
            return this;
        }

        public Builder status(Function<RollupJobStatus.Builder, ObjectBuilder<RollupJobStatus>> fn) {
            return this.status(fn.apply(new RollupJobStatus.Builder()).build());
        }

        @Override
        public RollupJob build() {
            return new RollupJob(this);
        }
    }
}

