/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.rollup.StopJobResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class StopJobRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<StopJobRequest, StopJobResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StopJobRequest, StopJobResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_rollup");
            buf.append("/job");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_stop");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StopJobResponse._DESERIALIZER);

    public StopJobRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.timeout = builder.timeout;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public StopJobRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    implements ObjectBuilder<StopJobRequest> {
        private String id;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean waitForCompletion;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public StopJobRequest build() {
            return new StopJobRequest(this);
        }
    }
}

