/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch.rollup.DateHistogramGrouping;
import co.elastic.clients.elasticsearch.rollup.HistogramGrouping;
import co.elastic.clients.elasticsearch.rollup.TermsGrouping;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Groupings
implements JsonpSerializable {
    @Nullable
    private final DateHistogramGrouping dateHistogram;
    @Nullable
    private final HistogramGrouping histogram;
    @Nullable
    private final TermsGrouping terms;
    public static final JsonpDeserializer<Groupings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Groupings::setupGroupingsDeserializer, Builder::build);

    public Groupings(Builder builder) {
        this.dateHistogram = builder.dateHistogram;
        this.histogram = builder.histogram;
        this.terms = builder.terms;
    }

    public Groupings(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public DateHistogramGrouping dateHistogram() {
        return this.dateHistogram;
    }

    @Nullable
    public HistogramGrouping histogram() {
        return this.histogram;
    }

    @Nullable
    public TermsGrouping terms() {
        return this.terms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dateHistogram != null) {
            generator.writeKey("date_histogram");
            this.dateHistogram.serialize(generator, mapper);
        }
        if (this.histogram != null) {
            generator.writeKey("histogram");
            this.histogram.serialize(generator, mapper);
        }
        if (this.terms != null) {
            generator.writeKey("terms");
            this.terms.serialize(generator, mapper);
        }
    }

    protected static void setupGroupingsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::dateHistogram, DateHistogramGrouping._DESERIALIZER, "date_histogram", new String[0]);
        op.add(Builder::histogram, HistogramGrouping._DESERIALIZER, "histogram", new String[0]);
        op.add(Builder::terms, TermsGrouping._DESERIALIZER, "terms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Groupings> {
        @Nullable
        private DateHistogramGrouping dateHistogram;
        @Nullable
        private HistogramGrouping histogram;
        @Nullable
        private TermsGrouping terms;

        public Builder dateHistogram(@Nullable DateHistogramGrouping value) {
            this.dateHistogram = value;
            return this;
        }

        public Builder dateHistogram(Function<DateHistogramGrouping.Builder, ObjectBuilder<DateHistogramGrouping>> fn) {
            return this.dateHistogram(fn.apply(new DateHistogramGrouping.Builder()).build());
        }

        public Builder histogram(@Nullable HistogramGrouping value) {
            this.histogram = value;
            return this;
        }

        public Builder histogram(Function<HistogramGrouping.Builder, ObjectBuilder<HistogramGrouping>> fn) {
            return this.histogram(fn.apply(new HistogramGrouping.Builder()).build());
        }

        public Builder terms(@Nullable TermsGrouping value) {
            this.terms = value;
            return this;
        }

        public Builder terms(Function<TermsGrouping.Builder, ObjectBuilder<TermsGrouping>> fn) {
            return this.terms(fn.apply(new TermsGrouping.Builder()).build());
        }

        @Override
        public Groupings build() {
            return new Groupings(this);
        }
    }
}

