/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DateHistogramGrouping
implements JsonpSerializable {
    @Nullable
    private final String delay;
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final String interval;
    @Nullable
    private final String calendarInterval;
    @Nullable
    private final String fixedInterval;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<DateHistogramGrouping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateHistogramGrouping::setupDateHistogramGroupingDeserializer, Builder::build);

    public DateHistogramGrouping(Builder builder) {
        this.delay = builder.delay;
        this.field = Objects.requireNonNull(builder.field, "field");
        this.format = builder.format;
        this.interval = builder.interval;
        this.calendarInterval = builder.calendarInterval;
        this.fixedInterval = builder.fixedInterval;
        this.timeZone = builder.timeZone;
    }

    public DateHistogramGrouping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String delay() {
        return this.delay;
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public String interval() {
        return this.interval;
    }

    @Nullable
    public String calendarInterval() {
        return this.calendarInterval;
    }

    @Nullable
    public String fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public String timeZone() {
        return this.timeZone;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.delay != null) {
            generator.writeKey("delay");
            generator.write(this.delay);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.interval != null) {
            generator.writeKey("interval");
            generator.write(this.interval);
        }
        if (this.calendarInterval != null) {
            generator.writeKey("calendar_interval");
            generator.write(this.calendarInterval);
        }
        if (this.fixedInterval != null) {
            generator.writeKey("fixed_interval");
            generator.write(this.fixedInterval);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    protected static void setupDateHistogramGroupingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::delay, JsonpDeserializer.stringDeserializer(), "delay", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::interval, JsonpDeserializer.stringDeserializer(), "interval", new String[0]);
        op.add(Builder::calendarInterval, JsonpDeserializer.stringDeserializer(), "calendar_interval", new String[0]);
        op.add(Builder::fixedInterval, JsonpDeserializer.stringDeserializer(), "fixed_interval", new String[0]);
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DateHistogramGrouping> {
        @Nullable
        private String delay;
        private String field;
        @Nullable
        private String format;
        @Nullable
        private String interval;
        @Nullable
        private String calendarInterval;
        @Nullable
        private String fixedInterval;
        @Nullable
        private String timeZone;

        public Builder delay(@Nullable String value) {
            this.delay = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder interval(@Nullable String value) {
            this.interval = value;
            return this;
        }

        public Builder calendarInterval(@Nullable String value) {
            this.calendarInterval = value;
            return this;
        }

        public Builder fixedInterval(@Nullable String value) {
            this.fixedInterval = value;
            return this;
        }

        public Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        public DateHistogramGrouping build() {
            return new DateHistogramGrouping(this);
        }
    }
}

