/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoMemory;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoOSCPU;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeOperatingSystemInfo
implements JsonpSerializable {
    private final String arch;
    private final int availableProcessors;
    @Nullable
    private final Integer allocatedProcessors;
    private final String name;
    private final String prettyName;
    private final int refreshIntervalInMillis;
    private final String version;
    @Nullable
    private final NodeInfoOSCPU cpu;
    @Nullable
    private final NodeInfoMemory mem;
    @Nullable
    private final NodeInfoMemory swap;
    public static final JsonpDeserializer<NodeOperatingSystemInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeOperatingSystemInfo::setupNodeOperatingSystemInfoDeserializer, Builder::build);

    public NodeOperatingSystemInfo(Builder builder) {
        this.arch = Objects.requireNonNull(builder.arch, "arch");
        this.availableProcessors = Objects.requireNonNull(builder.availableProcessors, "available_processors");
        this.allocatedProcessors = builder.allocatedProcessors;
        this.name = Objects.requireNonNull(builder.name, "name");
        this.prettyName = Objects.requireNonNull(builder.prettyName, "pretty_name");
        this.refreshIntervalInMillis = Objects.requireNonNull(builder.refreshIntervalInMillis, "refresh_interval_in_millis");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.cpu = builder.cpu;
        this.mem = builder.mem;
        this.swap = builder.swap;
    }

    public NodeOperatingSystemInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String arch() {
        return this.arch;
    }

    public int availableProcessors() {
        return this.availableProcessors;
    }

    @Nullable
    public Integer allocatedProcessors() {
        return this.allocatedProcessors;
    }

    public String name() {
        return this.name;
    }

    public String prettyName() {
        return this.prettyName;
    }

    public int refreshIntervalInMillis() {
        return this.refreshIntervalInMillis;
    }

    public String version() {
        return this.version;
    }

    @Nullable
    public NodeInfoOSCPU cpu() {
        return this.cpu;
    }

    @Nullable
    public NodeInfoMemory mem() {
        return this.mem;
    }

    @Nullable
    public NodeInfoMemory swap() {
        return this.swap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("arch");
        generator.write(this.arch);
        generator.writeKey("available_processors");
        generator.write(this.availableProcessors);
        if (this.allocatedProcessors != null) {
            generator.writeKey("allocated_processors");
            generator.write(this.allocatedProcessors.intValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("pretty_name");
        generator.write(this.prettyName);
        generator.writeKey("refresh_interval_in_millis");
        generator.write(this.refreshIntervalInMillis);
        generator.writeKey("version");
        generator.write(this.version);
        if (this.cpu != null) {
            generator.writeKey("cpu");
            this.cpu.serialize(generator, mapper);
        }
        if (this.mem != null) {
            generator.writeKey("mem");
            this.mem.serialize(generator, mapper);
        }
        if (this.swap != null) {
            generator.writeKey("swap");
            this.swap.serialize(generator, mapper);
        }
    }

    protected static void setupNodeOperatingSystemInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::arch, JsonpDeserializer.stringDeserializer(), "arch", new String[0]);
        op.add(Builder::availableProcessors, JsonpDeserializer.integerDeserializer(), "available_processors", new String[0]);
        op.add(Builder::allocatedProcessors, JsonpDeserializer.integerDeserializer(), "allocated_processors", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::prettyName, JsonpDeserializer.stringDeserializer(), "pretty_name", new String[0]);
        op.add(Builder::refreshIntervalInMillis, JsonpDeserializer.integerDeserializer(), "refresh_interval_in_millis", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::cpu, NodeInfoOSCPU._DESERIALIZER, "cpu", new String[0]);
        op.add(Builder::mem, NodeInfoMemory._DESERIALIZER, "mem", new String[0]);
        op.add(Builder::swap, NodeInfoMemory._DESERIALIZER, "swap", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeOperatingSystemInfo> {
        private String arch;
        private Integer availableProcessors;
        @Nullable
        private Integer allocatedProcessors;
        private String name;
        private String prettyName;
        private Integer refreshIntervalInMillis;
        private String version;
        @Nullable
        private NodeInfoOSCPU cpu;
        @Nullable
        private NodeInfoMemory mem;
        @Nullable
        private NodeInfoMemory swap;

        public Builder arch(String value) {
            this.arch = value;
            return this;
        }

        public Builder availableProcessors(int value) {
            this.availableProcessors = value;
            return this;
        }

        public Builder allocatedProcessors(@Nullable Integer value) {
            this.allocatedProcessors = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder prettyName(String value) {
            this.prettyName = value;
            return this;
        }

        public Builder refreshIntervalInMillis(int value) {
            this.refreshIntervalInMillis = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder cpu(@Nullable NodeInfoOSCPU value) {
            this.cpu = value;
            return this;
        }

        public Builder cpu(Function<NodeInfoOSCPU.Builder, ObjectBuilder<NodeInfoOSCPU>> fn) {
            return this.cpu(fn.apply(new NodeInfoOSCPU.Builder()).build());
        }

        public Builder mem(@Nullable NodeInfoMemory value) {
            this.mem = value;
            return this;
        }

        public Builder mem(Function<NodeInfoMemory.Builder, ObjectBuilder<NodeInfoMemory>> fn) {
            return this.mem(fn.apply(new NodeInfoMemory.Builder()).build());
        }

        public Builder swap(@Nullable NodeInfoMemory value) {
            this.swap = value;
            return this;
        }

        public Builder swap(Function<NodeInfoMemory.Builder, ObjectBuilder<NodeInfoMemory>> fn) {
            return this.swap(fn.apply(new NodeInfoMemory.Builder()).build());
        }

        @Override
        public NodeOperatingSystemInfo build() {
            return new NodeOperatingSystemInfo(this);
        }
    }
}

