/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeInfoPath
implements JsonpSerializable {
    private final String logs;
    private final String home;
    private final List<String> repo;
    @Nullable
    private final List<String> data;
    public static final JsonpDeserializer<NodeInfoPath> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoPath::setupNodeInfoPathDeserializer, Builder::build);

    public NodeInfoPath(Builder builder) {
        this.logs = Objects.requireNonNull(builder.logs, "logs");
        this.home = Objects.requireNonNull(builder.home, "home");
        this.repo = ModelTypeHelper.unmodifiableNonNull(builder.repo, "repo");
        this.data = ModelTypeHelper.unmodifiable(builder.data);
    }

    public NodeInfoPath(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String logs() {
        return this.logs;
    }

    public String home() {
        return this.home;
    }

    public List<String> repo() {
        return this.repo;
    }

    @Nullable
    public List<String> data() {
        return this.data;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("logs");
        generator.write(this.logs);
        generator.writeKey("home");
        generator.write(this.home);
        generator.writeKey("repo");
        generator.writeStartArray();
        for (String item0 : this.repo) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.data != null) {
            generator.writeKey("data");
            generator.writeStartArray();
            for (String item0 : this.data) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNodeInfoPathDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::logs, JsonpDeserializer.stringDeserializer(), "logs", new String[0]);
        op.add(Builder::home, JsonpDeserializer.stringDeserializer(), "home", new String[0]);
        op.add(Builder::repo, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "repo", new String[0]);
        op.add(Builder::data, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "data", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoPath> {
        private String logs;
        private String home;
        private List<String> repo;
        @Nullable
        private List<String> data;

        public Builder logs(String value) {
            this.logs = value;
            return this;
        }

        public Builder home(String value) {
            this.home = value;
            return this;
        }

        public Builder repo(List<String> value) {
            this.repo = value;
            return this;
        }

        public Builder repo(String ... value) {
            this.repo = Arrays.asList(value);
            return this;
        }

        public Builder addRepo(String value) {
            if (this.repo == null) {
                this.repo = new ArrayList<String>();
            }
            this.repo.add(value);
            return this;
        }

        public Builder data(@Nullable List<String> value) {
            this.data = value;
            return this;
        }

        public Builder data(String ... value) {
            this.data = Arrays.asList(value);
            return this;
        }

        public Builder addData(String value) {
            if (this.data == null) {
                this.data = new ArrayList<String>();
            }
            this.data.add(value);
            return this;
        }

        @Override
        public NodeInfoPath build() {
            return new NodeInfoPath(this);
        }
    }
}

