/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoNetworkInterface;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeInfoNetwork
implements JsonpSerializable {
    private final NodeInfoNetworkInterface primaryInterface;
    private final int refreshInterval;
    public static final JsonpDeserializer<NodeInfoNetwork> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoNetwork::setupNodeInfoNetworkDeserializer, Builder::build);

    public NodeInfoNetwork(Builder builder) {
        this.primaryInterface = Objects.requireNonNull(builder.primaryInterface, "primary_interface");
        this.refreshInterval = Objects.requireNonNull(builder.refreshInterval, "refresh_interval");
    }

    public NodeInfoNetwork(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public NodeInfoNetworkInterface primaryInterface() {
        return this.primaryInterface;
    }

    public int refreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("primary_interface");
        this.primaryInterface.serialize(generator, mapper);
        generator.writeKey("refresh_interval");
        generator.write(this.refreshInterval);
    }

    protected static void setupNodeInfoNetworkDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::primaryInterface, NodeInfoNetworkInterface._DESERIALIZER, "primary_interface", new String[0]);
        op.add(Builder::refreshInterval, JsonpDeserializer.integerDeserializer(), "refresh_interval", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoNetwork> {
        private NodeInfoNetworkInterface primaryInterface;
        private Integer refreshInterval;

        public Builder primaryInterface(NodeInfoNetworkInterface value) {
            this.primaryInterface = value;
            return this;
        }

        public Builder primaryInterface(Function<NodeInfoNetworkInterface.Builder, ObjectBuilder<NodeInfoNetworkInterface>> fn) {
            return this.primaryInterface(fn.apply(new NodeInfoNetworkInterface.Builder()).build());
        }

        public Builder refreshInterval(int value) {
            this.refreshInterval = value;
            return this;
        }

        @Override
        public NodeInfoNetwork build() {
            return new NodeInfoNetwork(this);
        }
    }
}

