/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeInfoHttp
implements JsonpSerializable {
    private final List<String> boundAddress;
    @Nullable
    private final String maxContentLength;
    private final long maxContentLengthInBytes;
    private final String publishAddress;
    public static final JsonpDeserializer<NodeInfoHttp> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoHttp::setupNodeInfoHttpDeserializer, Builder::build);

    public NodeInfoHttp(Builder builder) {
        this.boundAddress = ModelTypeHelper.unmodifiableNonNull(builder.boundAddress, "bound_address");
        this.maxContentLength = builder.maxContentLength;
        this.maxContentLengthInBytes = Objects.requireNonNull(builder.maxContentLengthInBytes, "max_content_length_in_bytes");
        this.publishAddress = Objects.requireNonNull(builder.publishAddress, "publish_address");
    }

    public NodeInfoHttp(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> boundAddress() {
        return this.boundAddress;
    }

    @Nullable
    public String maxContentLength() {
        return this.maxContentLength;
    }

    public long maxContentLengthInBytes() {
        return this.maxContentLengthInBytes;
    }

    public String publishAddress() {
        return this.publishAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bound_address");
        generator.writeStartArray();
        for (String item0 : this.boundAddress) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.maxContentLength != null) {
            generator.writeKey("max_content_length");
            generator.write(this.maxContentLength);
        }
        generator.writeKey("max_content_length_in_bytes");
        generator.write(this.maxContentLengthInBytes);
        generator.writeKey("publish_address");
        generator.write(this.publishAddress);
    }

    protected static void setupNodeInfoHttpDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::boundAddress, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "bound_address", new String[0]);
        op.add(Builder::maxContentLength, JsonpDeserializer.stringDeserializer(), "max_content_length", new String[0]);
        op.add(Builder::maxContentLengthInBytes, JsonpDeserializer.longDeserializer(), "max_content_length_in_bytes", new String[0]);
        op.add(Builder::publishAddress, JsonpDeserializer.stringDeserializer(), "publish_address", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoHttp> {
        private List<String> boundAddress;
        @Nullable
        private String maxContentLength;
        private Long maxContentLengthInBytes;
        private String publishAddress;

        public Builder boundAddress(List<String> value) {
            this.boundAddress = value;
            return this;
        }

        public Builder boundAddress(String ... value) {
            this.boundAddress = Arrays.asList(value);
            return this;
        }

        public Builder addBoundAddress(String value) {
            if (this.boundAddress == null) {
                this.boundAddress = new ArrayList<String>();
            }
            this.boundAddress.add(value);
            return this;
        }

        public Builder maxContentLength(@Nullable String value) {
            this.maxContentLength = value;
            return this;
        }

        public Builder maxContentLengthInBytes(long value) {
            this.maxContentLengthInBytes = value;
            return this;
        }

        public Builder publishAddress(String value) {
            this.publishAddress = value;
            return this;
        }

        @Override
        public NodeInfoHttp build() {
            return new NodeInfoHttp(this);
        }
    }
}

