/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ThreadCount
implements JsonpSerializable {
    private final long active;
    private final long completed;
    private final long largest;
    private final long queue;
    private final long rejected;
    private final long threads;
    public static final JsonpDeserializer<ThreadCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ThreadCount::setupThreadCountDeserializer, Builder::build);

    public ThreadCount(Builder builder) {
        this.active = Objects.requireNonNull(builder.active, "active");
        this.completed = Objects.requireNonNull(builder.completed, "completed");
        this.largest = Objects.requireNonNull(builder.largest, "largest");
        this.queue = Objects.requireNonNull(builder.queue, "queue");
        this.rejected = Objects.requireNonNull(builder.rejected, "rejected");
        this.threads = Objects.requireNonNull(builder.threads, "threads");
    }

    public ThreadCount(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long active() {
        return this.active;
    }

    public long completed() {
        return this.completed;
    }

    public long largest() {
        return this.largest;
    }

    public long queue() {
        return this.queue;
    }

    public long rejected() {
        return this.rejected;
    }

    public long threads() {
        return this.threads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active");
        generator.write(this.active);
        generator.writeKey("completed");
        generator.write(this.completed);
        generator.writeKey("largest");
        generator.write(this.largest);
        generator.writeKey("queue");
        generator.write(this.queue);
        generator.writeKey("rejected");
        generator.write(this.rejected);
        generator.writeKey("threads");
        generator.write(this.threads);
    }

    protected static void setupThreadCountDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::active, JsonpDeserializer.longDeserializer(), "active", new String[0]);
        op.add(Builder::completed, JsonpDeserializer.longDeserializer(), "completed", new String[0]);
        op.add(Builder::largest, JsonpDeserializer.longDeserializer(), "largest", new String[0]);
        op.add(Builder::queue, JsonpDeserializer.longDeserializer(), "queue", new String[0]);
        op.add(Builder::rejected, JsonpDeserializer.longDeserializer(), "rejected", new String[0]);
        op.add(Builder::threads, JsonpDeserializer.longDeserializer(), "threads", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ThreadCount> {
        private Long active;
        private Long completed;
        private Long largest;
        private Long queue;
        private Long rejected;
        private Long threads;

        public Builder active(long value) {
            this.active = value;
            return this;
        }

        public Builder completed(long value) {
            this.completed = value;
            return this;
        }

        public Builder largest(long value) {
            this.largest = value;
            return this;
        }

        public Builder queue(long value) {
            this.queue = value;
            return this;
        }

        public Builder rejected(long value) {
            this.rejected = value;
            return this;
        }

        public Builder threads(long value) {
            this.threads = value;
            return this;
        }

        @Override
        public ThreadCount build() {
            return new ThreadCount(this);
        }
    }
}

