/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class JvmThreads
implements JsonpSerializable {
    private final long count;
    private final long peakCount;
    public static final JsonpDeserializer<JvmThreads> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JvmThreads::setupJvmThreadsDeserializer, Builder::build);

    public JvmThreads(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.peakCount = Objects.requireNonNull(builder.peakCount, "peak_count");
    }

    public JvmThreads(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public long peakCount() {
        return this.peakCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("peak_count");
        generator.write(this.peakCount);
    }

    protected static void setupJvmThreadsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::peakCount, JsonpDeserializer.longDeserializer(), "peak_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<JvmThreads> {
        private Long count;
        private Long peakCount;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder peakCount(long value) {
            this.peakCount = value;
            return this;
        }

        @Override
        public JvmThreads build() {
            return new JvmThreads(this);
        }
    }
}

