/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.NodesResponseBase;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class InfoResponse
extends NodesResponseBase {
    private final String clusterName;
    private final Map<String, NodeInfo> nodes;
    public static final JsonpDeserializer<InfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InfoResponse::setupInfoResponseDeserializer, Builder::build);

    public InfoResponse(Builder builder) {
        super(builder);
        this.clusterName = Objects.requireNonNull(builder.clusterName, "cluster_name");
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
    }

    public InfoResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String clusterName() {
        return this.clusterName;
    }

    public Map<String, NodeInfo> nodes() {
        return this.nodes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, NodeInfo> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupInfoResponseDeserializer(DelegatingDeserializer<Builder> op) {
        NodesResponseBase.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name", new String[0]);
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeInfo._DESERIALIZER), "nodes", new String[0]);
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InfoResponse> {
        private String clusterName;
        private Map<String, NodeInfo> nodes;

        public Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public Builder nodes(Map<String, NodeInfo> value) {
            this.nodes = value;
            return this;
        }

        public Builder putNodes(String key, NodeInfo value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, NodeInfo>();
            }
            this.nodes.put(key, value);
            return this;
        }

        public Builder nodes(String key, Function<NodeInfo.Builder, ObjectBuilder<NodeInfo>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new NodeInfo.Builder()).build()));
        }

        public Builder putNodes(String key, Function<NodeInfo.Builder, ObjectBuilder<NodeInfo>> fn) {
            return this.putNodes(key, fn.apply(new NodeInfo.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InfoResponse build() {
            return new InfoResponse(this);
        }
    }
}

