/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.GarbageCollectorTotal;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class GarbageCollector
implements JsonpSerializable {
    private final Map<String, GarbageCollectorTotal> collectors;
    public static final JsonpDeserializer<GarbageCollector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GarbageCollector::setupGarbageCollectorDeserializer, Builder::build);

    public GarbageCollector(Builder builder) {
        this.collectors = ModelTypeHelper.unmodifiableNonNull(builder.collectors, "collectors");
    }

    public GarbageCollector(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, GarbageCollectorTotal> collectors() {
        return this.collectors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("collectors");
        generator.writeStartObject();
        for (Map.Entry<String, GarbageCollectorTotal> item0 : this.collectors.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGarbageCollectorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::collectors, JsonpDeserializer.stringMapDeserializer(GarbageCollectorTotal._DESERIALIZER), "collectors", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GarbageCollector> {
        private Map<String, GarbageCollectorTotal> collectors;

        public Builder collectors(Map<String, GarbageCollectorTotal> value) {
            this.collectors = value;
            return this;
        }

        public Builder putCollectors(String key, GarbageCollectorTotal value) {
            if (this.collectors == null) {
                this.collectors = new HashMap<String, GarbageCollectorTotal>();
            }
            this.collectors.put(key, value);
            return this;
        }

        public Builder collectors(String key, Function<GarbageCollectorTotal.Builder, ObjectBuilder<GarbageCollectorTotal>> fn) {
            return this.collectors(Collections.singletonMap(key, fn.apply(new GarbageCollectorTotal.Builder()).build()));
        }

        public Builder putCollectors(String key, Function<GarbageCollectorTotal.Builder, ObjectBuilder<GarbageCollectorTotal>> fn) {
            return this.putCollectors(key, fn.apply(new GarbageCollectorTotal.Builder()).build());
        }

        @Override
        public GarbageCollector build() {
            return new GarbageCollector(this);
        }
    }
}

