/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.TrainedModelTreeNode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TrainedModelTree
implements JsonpSerializable {
    @Nullable
    private final List<String> classificationLabels;
    private final List<String> featureNames;
    @Nullable
    private final String targetType;
    private final List<TrainedModelTreeNode> treeStructure;
    public static final JsonpDeserializer<TrainedModelTree> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelTree::setupTrainedModelTreeDeserializer, Builder::build);

    public TrainedModelTree(Builder builder) {
        this.classificationLabels = ModelTypeHelper.unmodifiable(builder.classificationLabels);
        this.featureNames = ModelTypeHelper.unmodifiableNonNull(builder.featureNames, "feature_names");
        this.targetType = builder.targetType;
        this.treeStructure = ModelTypeHelper.unmodifiableNonNull(builder.treeStructure, "tree_structure");
    }

    public TrainedModelTree(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> classificationLabels() {
        return this.classificationLabels;
    }

    public List<String> featureNames() {
        return this.featureNames;
    }

    @Nullable
    public String targetType() {
        return this.targetType;
    }

    public List<TrainedModelTreeNode> treeStructure() {
        return this.treeStructure;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.classificationLabels != null) {
            generator.writeKey("classification_labels");
            generator.writeStartArray();
            for (String string : this.classificationLabels) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("feature_names");
        generator.writeStartArray();
        for (String string : this.featureNames) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.targetType != null) {
            generator.writeKey("target_type");
            generator.write(this.targetType);
        }
        generator.writeKey("tree_structure");
        generator.writeStartArray();
        for (TrainedModelTreeNode trainedModelTreeNode : this.treeStructure) {
            trainedModelTreeNode.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTrainedModelTreeDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::classificationLabels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "classification_labels", new String[0]);
        op.add(Builder::featureNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "feature_names", new String[0]);
        op.add(Builder::targetType, JsonpDeserializer.stringDeserializer(), "target_type", new String[0]);
        op.add(Builder::treeStructure, JsonpDeserializer.arrayDeserializer(TrainedModelTreeNode._DESERIALIZER), "tree_structure", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TrainedModelTree> {
        @Nullable
        private List<String> classificationLabels;
        private List<String> featureNames;
        @Nullable
        private String targetType;
        private List<TrainedModelTreeNode> treeStructure;

        public Builder classificationLabels(@Nullable List<String> value) {
            this.classificationLabels = value;
            return this;
        }

        public Builder classificationLabels(String ... value) {
            this.classificationLabels = Arrays.asList(value);
            return this;
        }

        public Builder addClassificationLabels(String value) {
            if (this.classificationLabels == null) {
                this.classificationLabels = new ArrayList<String>();
            }
            this.classificationLabels.add(value);
            return this;
        }

        public Builder featureNames(List<String> value) {
            this.featureNames = value;
            return this;
        }

        public Builder featureNames(String ... value) {
            this.featureNames = Arrays.asList(value);
            return this;
        }

        public Builder addFeatureNames(String value) {
            if (this.featureNames == null) {
                this.featureNames = new ArrayList<String>();
            }
            this.featureNames.add(value);
            return this;
        }

        public Builder targetType(@Nullable String value) {
            this.targetType = value;
            return this;
        }

        public Builder treeStructure(List<TrainedModelTreeNode> value) {
            this.treeStructure = value;
            return this;
        }

        public Builder treeStructure(TrainedModelTreeNode ... value) {
            this.treeStructure = Arrays.asList(value);
            return this;
        }

        public Builder addTreeStructure(TrainedModelTreeNode value) {
            if (this.treeStructure == null) {
                this.treeStructure = new ArrayList<TrainedModelTreeNode>();
            }
            this.treeStructure.add(value);
            return this;
        }

        public Builder treeStructure(Function<TrainedModelTreeNode.Builder, ObjectBuilder<TrainedModelTreeNode>> fn) {
            return this.treeStructure(fn.apply(new TrainedModelTreeNode.Builder()).build());
        }

        public Builder addTreeStructure(Function<TrainedModelTreeNode.Builder, ObjectBuilder<TrainedModelTreeNode>> fn) {
            return this.addTreeStructure(fn.apply(new TrainedModelTreeNode.Builder()).build());
        }

        @Override
        public TrainedModelTree build() {
            return new TrainedModelTree(this);
        }
    }
}

