/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.PreprocessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class OneHotEncodingPreprocessor
implements PreprocessorVariant,
JsonpSerializable {
    private final String field;
    private final Map<String, String> hotMap;
    public static final JsonpDeserializer<OneHotEncodingPreprocessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OneHotEncodingPreprocessor::setupOneHotEncodingPreprocessorDeserializer, Builder::build);

    public OneHotEncodingPreprocessor(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.hotMap = ModelTypeHelper.unmodifiableNonNull(builder.hotMap, "hot_map");
    }

    public OneHotEncodingPreprocessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "one_hot_encoding";
    }

    public String field() {
        return this.field;
    }

    public Map<String, String> hotMap() {
        return this.hotMap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("hot_map");
        generator.writeStartObject();
        for (Map.Entry<String, String> item0 : this.hotMap.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue());
        }
        generator.writeEnd();
    }

    protected static void setupOneHotEncodingPreprocessorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::hotMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "hot_map", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<OneHotEncodingPreprocessor> {
        private String field;
        private Map<String, String> hotMap;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder hotMap(Map<String, String> value) {
            this.hotMap = value;
            return this;
        }

        public Builder putHotMap(String key, String value) {
            if (this.hotMap == null) {
                this.hotMap = new HashMap<String, String>();
            }
            this.hotMap.put(key, value);
            return this;
        }

        @Override
        public OneHotEncodingPreprocessor build() {
            return new OneHotEncodingPreprocessor(this);
        }
    }
}

