/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.AggregateOutput;
import co.elastic.clients.elasticsearch.ml.put_trained_model.TrainedModel;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Ensemble
implements JsonpSerializable {
    @Nullable
    private final AggregateOutput aggregateOutput;
    @Nullable
    private final List<String> classificationLabels;
    @Nullable
    private final List<String> featureNames;
    @Nullable
    private final String targetType;
    private final List<TrainedModel> trainedModels;
    public static final JsonpDeserializer<Ensemble> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ensemble::setupEnsembleDeserializer, Builder::build);

    public Ensemble(Builder builder) {
        this.aggregateOutput = builder.aggregateOutput;
        this.classificationLabels = ModelTypeHelper.unmodifiable(builder.classificationLabels);
        this.featureNames = ModelTypeHelper.unmodifiable(builder.featureNames);
        this.targetType = builder.targetType;
        this.trainedModels = ModelTypeHelper.unmodifiableNonNull(builder.trainedModels, "trained_models");
    }

    public Ensemble(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public AggregateOutput aggregateOutput() {
        return this.aggregateOutput;
    }

    @Nullable
    public List<String> classificationLabels() {
        return this.classificationLabels;
    }

    @Nullable
    public List<String> featureNames() {
        return this.featureNames;
    }

    @Nullable
    public String targetType() {
        return this.targetType;
    }

    public List<TrainedModel> trainedModels() {
        return this.trainedModels;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggregateOutput != null) {
            generator.writeKey("aggregate_output");
            this.aggregateOutput.serialize(generator, mapper);
        }
        if (this.classificationLabels != null) {
            generator.writeKey("classification_labels");
            generator.writeStartArray();
            for (String string : this.classificationLabels) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.featureNames != null) {
            generator.writeKey("feature_names");
            generator.writeStartArray();
            for (String string : this.featureNames) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.targetType != null) {
            generator.writeKey("target_type");
            generator.write(this.targetType);
        }
        generator.writeKey("trained_models");
        generator.writeStartArray();
        for (TrainedModel trainedModel : this.trainedModels) {
            trainedModel.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupEnsembleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggregateOutput, AggregateOutput._DESERIALIZER, "aggregate_output", new String[0]);
        op.add(Builder::classificationLabels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "classification_labels", new String[0]);
        op.add(Builder::featureNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "feature_names", new String[0]);
        op.add(Builder::targetType, JsonpDeserializer.stringDeserializer(), "target_type", new String[0]);
        op.add(Builder::trainedModels, JsonpDeserializer.arrayDeserializer(TrainedModel._DESERIALIZER), "trained_models", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Ensemble> {
        @Nullable
        private AggregateOutput aggregateOutput;
        @Nullable
        private List<String> classificationLabels;
        @Nullable
        private List<String> featureNames;
        @Nullable
        private String targetType;
        private List<TrainedModel> trainedModels;

        public Builder aggregateOutput(@Nullable AggregateOutput value) {
            this.aggregateOutput = value;
            return this;
        }

        public Builder aggregateOutput(Function<AggregateOutput.Builder, ObjectBuilder<AggregateOutput>> fn) {
            return this.aggregateOutput(fn.apply(new AggregateOutput.Builder()).build());
        }

        public Builder classificationLabels(@Nullable List<String> value) {
            this.classificationLabels = value;
            return this;
        }

        public Builder classificationLabels(String ... value) {
            this.classificationLabels = Arrays.asList(value);
            return this;
        }

        public Builder addClassificationLabels(String value) {
            if (this.classificationLabels == null) {
                this.classificationLabels = new ArrayList<String>();
            }
            this.classificationLabels.add(value);
            return this;
        }

        public Builder featureNames(@Nullable List<String> value) {
            this.featureNames = value;
            return this;
        }

        public Builder featureNames(String ... value) {
            this.featureNames = Arrays.asList(value);
            return this;
        }

        public Builder addFeatureNames(String value) {
            if (this.featureNames == null) {
                this.featureNames = new ArrayList<String>();
            }
            this.featureNames.add(value);
            return this;
        }

        public Builder targetType(@Nullable String value) {
            this.targetType = value;
            return this;
        }

        public Builder trainedModels(List<TrainedModel> value) {
            this.trainedModels = value;
            return this;
        }

        public Builder trainedModels(TrainedModel ... value) {
            this.trainedModels = Arrays.asList(value);
            return this;
        }

        public Builder addTrainedModels(TrainedModel value) {
            if (this.trainedModels == null) {
                this.trainedModels = new ArrayList<TrainedModel>();
            }
            this.trainedModels.add(value);
            return this;
        }

        public Builder trainedModels(Function<TrainedModel.Builder, ObjectBuilder<TrainedModel>> fn) {
            return this.trainedModels(fn.apply(new TrainedModel.Builder()).build());
        }

        public Builder addTrainedModels(Function<TrainedModel.Builder, ObjectBuilder<TrainedModel>> fn) {
            return this.addTrainedModels(fn.apply(new TrainedModel.Builder()).build());
        }

        @Override
        public Ensemble build() {
            return new Ensemble(this);
        }
    }
}

