/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.Preprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.TrainedModel;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Definition
implements JsonpSerializable {
    @Nullable
    private final List<Preprocessor> preprocessors;
    private final TrainedModel trainedModel;
    public static final JsonpDeserializer<Definition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Definition::setupDefinitionDeserializer, Builder::build);

    public Definition(Builder builder) {
        this.preprocessors = ModelTypeHelper.unmodifiable(builder.preprocessors);
        this.trainedModel = Objects.requireNonNull(builder.trainedModel, "trained_model");
    }

    public Definition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<Preprocessor> preprocessors() {
        return this.preprocessors;
    }

    public TrainedModel trainedModel() {
        return this.trainedModel;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.preprocessors != null) {
            generator.writeKey("preprocessors");
            generator.writeStartArray();
            for (Preprocessor item0 : this.preprocessors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("trained_model");
        this.trainedModel.serialize(generator, mapper);
    }

    protected static void setupDefinitionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::preprocessors, JsonpDeserializer.arrayDeserializer(Preprocessor._DESERIALIZER), "preprocessors", new String[0]);
        op.add(Builder::trainedModel, TrainedModel._DESERIALIZER, "trained_model", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Definition> {
        @Nullable
        private List<Preprocessor> preprocessors;
        private TrainedModel trainedModel;

        public Builder preprocessors(@Nullable List<Preprocessor> value) {
            this.preprocessors = value;
            return this;
        }

        public Builder preprocessors(Preprocessor ... value) {
            this.preprocessors = Arrays.asList(value);
            return this;
        }

        public Builder addPreprocessors(Preprocessor value) {
            if (this.preprocessors == null) {
                this.preprocessors = new ArrayList<Preprocessor>();
            }
            this.preprocessors.add(value);
            return this;
        }

        public Builder preprocessors(Function<Preprocessor.Builder, ObjectBuilder<Preprocessor>> fn) {
            return this.preprocessors(fn.apply(new Preprocessor.Builder()).build());
        }

        public Builder addPreprocessors(Function<Preprocessor.Builder, ObjectBuilder<Preprocessor>> fn) {
            return this.addPreprocessors(fn.apply(new Preprocessor.Builder()).build());
        }

        public Builder trainedModel(TrainedModel value) {
            this.trainedModel = value;
            return this;
        }

        public Builder trainedModel(Function<TrainedModel.Builder, ObjectBuilder<TrainedModel>> fn) {
            return this.trainedModel(fn.apply(new TrainedModel.Builder()).build());
        }

        @Override
        public Definition build() {
            return new Definition(this);
        }
    }
}

