/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Limits
implements JsonpSerializable {
    @Nullable
    private final String maxModelMemoryLimit;
    private final String effectiveMaxModelMemoryLimit;
    private final String totalMlMemory;
    public static final JsonpDeserializer<Limits> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Limits::setupLimitsDeserializer, Builder::build);

    public Limits(Builder builder) {
        this.maxModelMemoryLimit = builder.maxModelMemoryLimit;
        this.effectiveMaxModelMemoryLimit = Objects.requireNonNull(builder.effectiveMaxModelMemoryLimit, "effective_max_model_memory_limit");
        this.totalMlMemory = Objects.requireNonNull(builder.totalMlMemory, "total_ml_memory");
    }

    public Limits(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String maxModelMemoryLimit() {
        return this.maxModelMemoryLimit;
    }

    public String effectiveMaxModelMemoryLimit() {
        return this.effectiveMaxModelMemoryLimit;
    }

    public String totalMlMemory() {
        return this.totalMlMemory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxModelMemoryLimit != null) {
            generator.writeKey("max_model_memory_limit");
            generator.write(this.maxModelMemoryLimit);
        }
        generator.writeKey("effective_max_model_memory_limit");
        generator.write(this.effectiveMaxModelMemoryLimit);
        generator.writeKey("total_ml_memory");
        generator.write(this.totalMlMemory);
    }

    protected static void setupLimitsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxModelMemoryLimit, JsonpDeserializer.stringDeserializer(), "max_model_memory_limit", new String[0]);
        op.add(Builder::effectiveMaxModelMemoryLimit, JsonpDeserializer.stringDeserializer(), "effective_max_model_memory_limit", new String[0]);
        op.add(Builder::totalMlMemory, JsonpDeserializer.stringDeserializer(), "total_ml_memory", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Limits> {
        @Nullable
        private String maxModelMemoryLimit;
        private String effectiveMaxModelMemoryLimit;
        private String totalMlMemory;

        public Builder maxModelMemoryLimit(@Nullable String value) {
            this.maxModelMemoryLimit = value;
            return this;
        }

        public Builder effectiveMaxModelMemoryLimit(String value) {
            this.effectiveMaxModelMemoryLimit = value;
            return this;
        }

        public Builder totalMlMemory(String value) {
            this.totalMlMemory = value;
            return this;
        }

        @Override
        public Limits build() {
            return new Limits(this);
        }
    }
}

