/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ValidationLoss
implements JsonpSerializable {
    private final List<String> foldValues;
    private final String lossType;
    public static final JsonpDeserializer<ValidationLoss> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ValidationLoss::setupValidationLossDeserializer, Builder::build);

    public ValidationLoss(Builder builder) {
        this.foldValues = ModelTypeHelper.unmodifiableNonNull(builder.foldValues, "fold_values");
        this.lossType = Objects.requireNonNull(builder.lossType, "loss_type");
    }

    public ValidationLoss(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> foldValues() {
        return this.foldValues;
    }

    public String lossType() {
        return this.lossType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fold_values");
        generator.writeStartArray();
        for (String item0 : this.foldValues) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("loss_type");
        generator.write(this.lossType);
    }

    protected static void setupValidationLossDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::foldValues, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fold_values", new String[0]);
        op.add(Builder::lossType, JsonpDeserializer.stringDeserializer(), "loss_type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ValidationLoss> {
        private List<String> foldValues;
        private String lossType;

        public Builder foldValues(List<String> value) {
            this.foldValues = value;
            return this;
        }

        public Builder foldValues(String ... value) {
            this.foldValues = Arrays.asList(value);
            return this;
        }

        public Builder addFoldValues(String value) {
            if (this.foldValues == null) {
                this.foldValues = new ArrayList<String>();
            }
            this.foldValues.add(value);
            return this;
        }

        public Builder lossType(String value) {
            this.lossType = value;
            return this;
        }

        @Override
        public ValidationLoss build() {
            return new ValidationLoss(this);
        }
    }
}

