/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TotalFeatureImportanceStatistics
implements JsonpSerializable {
    private final double meanMagnitude;
    private final int max;
    private final int min;
    public static final JsonpDeserializer<TotalFeatureImportanceStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TotalFeatureImportanceStatistics::setupTotalFeatureImportanceStatisticsDeserializer, Builder::build);

    public TotalFeatureImportanceStatistics(Builder builder) {
        this.meanMagnitude = Objects.requireNonNull(builder.meanMagnitude, "mean_magnitude");
        this.max = Objects.requireNonNull(builder.max, "max");
        this.min = Objects.requireNonNull(builder.min, "min");
    }

    public TotalFeatureImportanceStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double meanMagnitude() {
        return this.meanMagnitude;
    }

    public int max() {
        return this.max;
    }

    public int min() {
        return this.min;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("mean_magnitude");
        generator.write(this.meanMagnitude);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("min");
        generator.write(this.min);
    }

    protected static void setupTotalFeatureImportanceStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::meanMagnitude, JsonpDeserializer.doubleDeserializer(), "mean_magnitude", new String[0]);
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max", new String[0]);
        op.add(Builder::min, JsonpDeserializer.integerDeserializer(), "min", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TotalFeatureImportanceStatistics> {
        private Double meanMagnitude;
        private Integer max;
        private Integer min;

        public Builder meanMagnitude(double value) {
            this.meanMagnitude = value;
            return this;
        }

        public Builder max(int value) {
            this.max = value;
            return this;
        }

        public Builder min(int value) {
            this.min = value;
            return this;
        }

        @Override
        public TotalFeatureImportanceStatistics build() {
            return new TotalFeatureImportanceStatistics(this);
        }
    }
}

