/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TotalFeatureImportanceStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TotalFeatureImportanceClass
implements JsonpSerializable {
    private final String className;
    private final List<TotalFeatureImportanceStatistics> importance;
    public static final JsonpDeserializer<TotalFeatureImportanceClass> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TotalFeatureImportanceClass::setupTotalFeatureImportanceClassDeserializer, Builder::build);

    public TotalFeatureImportanceClass(Builder builder) {
        this.className = Objects.requireNonNull(builder.className, "class_name");
        this.importance = ModelTypeHelper.unmodifiableNonNull(builder.importance, "importance");
    }

    public TotalFeatureImportanceClass(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String className() {
        return this.className;
    }

    public List<TotalFeatureImportanceStatistics> importance() {
        return this.importance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("class_name");
        generator.write(this.className);
        generator.writeKey("importance");
        generator.writeStartArray();
        for (TotalFeatureImportanceStatistics item0 : this.importance) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTotalFeatureImportanceClassDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::className, JsonpDeserializer.stringDeserializer(), "class_name", new String[0]);
        op.add(Builder::importance, JsonpDeserializer.arrayDeserializer(TotalFeatureImportanceStatistics._DESERIALIZER), "importance", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TotalFeatureImportanceClass> {
        private String className;
        private List<TotalFeatureImportanceStatistics> importance;

        public Builder className(String value) {
            this.className = value;
            return this;
        }

        public Builder importance(List<TotalFeatureImportanceStatistics> value) {
            this.importance = value;
            return this;
        }

        public Builder importance(TotalFeatureImportanceStatistics ... value) {
            this.importance = Arrays.asList(value);
            return this;
        }

        public Builder addImportance(TotalFeatureImportanceStatistics value) {
            if (this.importance == null) {
                this.importance = new ArrayList<TotalFeatureImportanceStatistics>();
            }
            this.importance.add(value);
            return this;
        }

        public Builder importance(Function<TotalFeatureImportanceStatistics.Builder, ObjectBuilder<TotalFeatureImportanceStatistics>> fn) {
            return this.importance(fn.apply(new TotalFeatureImportanceStatistics.Builder()).build());
        }

        public Builder addImportance(Function<TotalFeatureImportanceStatistics.Builder, ObjectBuilder<TotalFeatureImportanceStatistics>> fn) {
            return this.addImportance(fn.apply(new TotalFeatureImportanceStatistics.Builder()).build());
        }

        @Override
        public TotalFeatureImportanceClass build() {
            return new TotalFeatureImportanceClass(this);
        }
    }
}

