/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.StopDatafeedResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class StopDatafeedRequest
extends RequestBase
implements JsonpSerializable {
    private final String datafeedId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean force;
    @Nullable
    private final String timeout;
    public static final JsonpDeserializer<StopDatafeedRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StopDatafeedRequest::setupStopDatafeedRequestDeserializer, Builder::build);
    public static final Endpoint<StopDatafeedRequest, StopDatafeedResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StopDatafeedRequest, StopDatafeedResponse>(request -> "POST", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            buf.append("/_stop");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, StopDatafeedResponse._DESERIALIZER);

    public StopDatafeedRequest(Builder builder) {
        this.datafeedId = Objects.requireNonNull(builder.datafeedId, "datafeed_id");
        this.allowNoMatch = builder.allowNoMatch;
        this.force = builder.force;
        this.timeout = builder.timeout;
    }

    public StopDatafeedRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Boolean force() {
        return this.force;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.force != null) {
            generator.writeKey("force");
            generator.write(this.force.booleanValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
    }

    protected static void setupStopDatafeedRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::force, JsonpDeserializer.booleanDeserializer(), "force", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StopDatafeedRequest> {
        private String datafeedId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean force;
        @Nullable
        private String timeout;

        public Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public StopDatafeedRequest build() {
            return new StopDatafeedRequest(this);
        }
    }
}

