/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsDestination;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutDataFrameAnalyticsResponse
implements JsonpSerializable {
    private final String id;
    private final long createTime;
    private final String version;
    private final DataframeAnalyticsSource source;
    @Nullable
    private final String description;
    private final DataframeAnalyticsDestination dest;
    private final String modelMemoryLimit;
    private final boolean allowLazyStart;
    private final int maxNumThreads;
    private final DataframeAnalysis analysis;
    @Nullable
    private final JsonValue analyzedFields;
    public static final JsonpDeserializer<PutDataFrameAnalyticsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDataFrameAnalyticsResponse::setupPutDataFrameAnalyticsResponseDeserializer, Builder::build);

    public PutDataFrameAnalyticsResponse(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.createTime = Objects.requireNonNull(builder.createTime, "create_time");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.source = Objects.requireNonNull(builder.source, "source");
        this.description = builder.description;
        this.dest = Objects.requireNonNull(builder.dest, "dest");
        this.modelMemoryLimit = Objects.requireNonNull(builder.modelMemoryLimit, "model_memory_limit");
        this.allowLazyStart = Objects.requireNonNull(builder.allowLazyStart, "allow_lazy_start");
        this.maxNumThreads = Objects.requireNonNull(builder.maxNumThreads, "max_num_threads");
        this.analysis = Objects.requireNonNull(builder.analysis, "analysis");
        this.analyzedFields = builder.analyzedFields;
    }

    public PutDataFrameAnalyticsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public long createTime() {
        return this.createTime;
    }

    public String version() {
        return this.version;
    }

    public DataframeAnalyticsSource source() {
        return this.source;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public DataframeAnalyticsDestination dest() {
        return this.dest;
    }

    public String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    public int maxNumThreads() {
        return this.maxNumThreads;
    }

    public DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public JsonValue analyzedFields() {
        return this.analyzedFields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("create_time");
        generator.write(this.createTime);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        generator.writeKey("model_memory_limit");
        generator.write(this.modelMemoryLimit);
        generator.writeKey("allow_lazy_start");
        generator.write(this.allowLazyStart);
        generator.writeKey("max_num_threads");
        generator.write(this.maxNumThreads);
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            generator.write(this.analyzedFields);
        }
    }

    protected static void setupPutDataFrameAnalyticsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::createTime, JsonpDeserializer.longDeserializer(), "create_time", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::dest, DataframeAnalyticsDestination._DESERIALIZER, "dest", new String[0]);
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit", new String[0]);
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start", new String[0]);
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads", new String[0]);
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis", new String[0]);
        op.add(Builder::analyzedFields, JsonpDeserializer.jsonValueDeserializer(), "analyzed_fields", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutDataFrameAnalyticsResponse> {
        private String id;
        private Long createTime;
        private String version;
        private DataframeAnalyticsSource source;
        @Nullable
        private String description;
        private DataframeAnalyticsDestination dest;
        private String modelMemoryLimit;
        private Boolean allowLazyStart;
        private Integer maxNumThreads;
        private DataframeAnalysis analysis;
        @Nullable
        private JsonValue analyzedFields;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder createTime(long value) {
            this.createTime = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder source(DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder dest(DataframeAnalyticsDestination value) {
            this.dest = value;
            return this;
        }

        public Builder dest(Function<DataframeAnalyticsDestination.Builder, ObjectBuilder<DataframeAnalyticsDestination>> fn) {
            return this.dest(fn.apply(new DataframeAnalyticsDestination.Builder()).build());
        }

        public Builder modelMemoryLimit(String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public Builder allowLazyStart(boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        public Builder maxNumThreads(int value) {
            this.maxNumThreads = value;
            return this;
        }

        public Builder analysis(DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public Builder analyzedFields(@Nullable JsonValue value) {
            this.analyzedFields = value;
            return this;
        }

        @Override
        public PutDataFrameAnalyticsResponse build() {
            return new PutDataFrameAnalyticsResponse(this);
        }
    }
}

