/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.OverallBucketJob;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class OverallBucket
implements JsonpSerializable {
    private final long bucketSpan;
    private final boolean isInterim;
    private final List<OverallBucketJob> jobs;
    private final double overallScore;
    private final String resultType;
    private final String timestamp;
    public static final JsonpDeserializer<OverallBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OverallBucket::setupOverallBucketDeserializer, Builder::build);

    public OverallBucket(Builder builder) {
        this.bucketSpan = Objects.requireNonNull(builder.bucketSpan, "bucket_span");
        this.isInterim = Objects.requireNonNull(builder.isInterim, "is_interim");
        this.jobs = ModelTypeHelper.unmodifiableNonNull(builder.jobs, "jobs");
        this.overallScore = Objects.requireNonNull(builder.overallScore, "overall_score");
        this.resultType = Objects.requireNonNull(builder.resultType, "result_type");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public OverallBucket(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long bucketSpan() {
        return this.bucketSpan;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public List<OverallBucketJob> jobs() {
        return this.jobs;
    }

    public double overallScore() {
        return this.overallScore;
    }

    public String resultType() {
        return this.resultType;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("jobs");
        generator.writeStartArray();
        for (OverallBucketJob item0 : this.jobs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("overall_score");
        generator.write(this.overallScore);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupOverallBucketDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bucketSpan, JsonpDeserializer.longDeserializer(), "bucket_span", new String[0]);
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim", new String[0]);
        op.add(Builder::jobs, JsonpDeserializer.arrayDeserializer(OverallBucketJob._DESERIALIZER), "jobs", new String[0]);
        op.add(Builder::overallScore, JsonpDeserializer.doubleDeserializer(), "overall_score", new String[0]);
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<OverallBucket> {
        private Long bucketSpan;
        private Boolean isInterim;
        private List<OverallBucketJob> jobs;
        private Double overallScore;
        private String resultType;
        private String timestamp;

        public Builder bucketSpan(long value) {
            this.bucketSpan = value;
            return this;
        }

        public Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public Builder jobs(List<OverallBucketJob> value) {
            this.jobs = value;
            return this;
        }

        public Builder jobs(OverallBucketJob ... value) {
            this.jobs = Arrays.asList(value);
            return this;
        }

        public Builder addJobs(OverallBucketJob value) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<OverallBucketJob>();
            }
            this.jobs.add(value);
            return this;
        }

        public Builder jobs(Function<OverallBucketJob.Builder, ObjectBuilder<OverallBucketJob>> fn) {
            return this.jobs(fn.apply(new OverallBucketJob.Builder()).build());
        }

        public Builder addJobs(Function<OverallBucketJob.Builder, ObjectBuilder<OverallBucketJob>> fn) {
            return this.addJobs(fn.apply(new OverallBucketJob.Builder()).build());
        }

        public Builder overallScore(double value) {
            this.overallScore = value;
            return this;
        }

        public Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public OverallBucket build() {
            return new OverallBucket(this);
        }
    }
}

