/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.JobStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class JobForecastStatistics
implements JsonpSerializable {
    @Nullable
    private final JobStatistics memoryBytes;
    @Nullable
    private final JobStatistics processingTimeMs;
    @Nullable
    private final JobStatistics records;
    @Nullable
    private final Map<String, Long> status;
    private final long total;
    private final int forecastedJobs;
    public static final JsonpDeserializer<JobForecastStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobForecastStatistics::setupJobForecastStatisticsDeserializer, Builder::build);

    public JobForecastStatistics(Builder builder) {
        this.memoryBytes = builder.memoryBytes;
        this.processingTimeMs = builder.processingTimeMs;
        this.records = builder.records;
        this.status = ModelTypeHelper.unmodifiable(builder.status);
        this.total = Objects.requireNonNull(builder.total, "total");
        this.forecastedJobs = Objects.requireNonNull(builder.forecastedJobs, "forecasted_jobs");
    }

    public JobForecastStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public JobStatistics memoryBytes() {
        return this.memoryBytes;
    }

    @Nullable
    public JobStatistics processingTimeMs() {
        return this.processingTimeMs;
    }

    @Nullable
    public JobStatistics records() {
        return this.records;
    }

    @Nullable
    public Map<String, Long> status() {
        return this.status;
    }

    public long total() {
        return this.total;
    }

    public int forecastedJobs() {
        return this.forecastedJobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.memoryBytes != null) {
            generator.writeKey("memory_bytes");
            this.memoryBytes.serialize(generator, mapper);
        }
        if (this.processingTimeMs != null) {
            generator.writeKey("processing_time_ms");
            this.processingTimeMs.serialize(generator, mapper);
        }
        if (this.records != null) {
            generator.writeKey("records");
            this.records.serialize(generator, mapper);
        }
        if (this.status != null) {
            generator.writeKey("status");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.status.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("forecasted_jobs");
        generator.write(this.forecastedJobs);
    }

    protected static void setupJobForecastStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::memoryBytes, JobStatistics._DESERIALIZER, "memory_bytes", new String[0]);
        op.add(Builder::processingTimeMs, JobStatistics._DESERIALIZER, "processing_time_ms", new String[0]);
        op.add(Builder::records, JobStatistics._DESERIALIZER, "records", new String[0]);
        op.add(Builder::status, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "status", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::forecastedJobs, JsonpDeserializer.integerDeserializer(), "forecasted_jobs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<JobForecastStatistics> {
        @Nullable
        private JobStatistics memoryBytes;
        @Nullable
        private JobStatistics processingTimeMs;
        @Nullable
        private JobStatistics records;
        @Nullable
        private Map<String, Long> status;
        private Long total;
        private Integer forecastedJobs;

        public Builder memoryBytes(@Nullable JobStatistics value) {
            this.memoryBytes = value;
            return this;
        }

        public Builder memoryBytes(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.memoryBytes(fn.apply(new JobStatistics.Builder()).build());
        }

        public Builder processingTimeMs(@Nullable JobStatistics value) {
            this.processingTimeMs = value;
            return this;
        }

        public Builder processingTimeMs(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.processingTimeMs(fn.apply(new JobStatistics.Builder()).build());
        }

        public Builder records(@Nullable JobStatistics value) {
            this.records = value;
            return this;
        }

        public Builder records(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.records(fn.apply(new JobStatistics.Builder()).build());
        }

        public Builder status(@Nullable Map<String, Long> value) {
            this.status = value;
            return this;
        }

        public Builder putStatus(String key, Long value) {
            if (this.status == null) {
                this.status = new HashMap<String, Long>();
            }
            this.status.put(key, value);
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        public Builder forecastedJobs(int value) {
            this.forecastedJobs = value;
            return this;
        }

        @Override
        public JobForecastStatistics build() {
            return new JobForecastStatistics(this);
        }
    }
}

