/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetRecordsResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetRecordsRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final Boolean desc;
    @Nullable
    private final Boolean excludeInterim;
    @Nullable
    private final Page page;
    @Nullable
    private final Double recordScore;
    @Nullable
    private final String sort;
    @Nullable
    private final String start;
    @Nullable
    private final String end;
    public static final JsonpDeserializer<GetRecordsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetRecordsRequest::setupGetRecordsRequestDeserializer, Builder::build);
    public static final Endpoint<GetRecordsRequest, GetRecordsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetRecordsRequest, GetRecordsResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/records");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetRecordsResponse._DESERIALIZER);

    public GetRecordsRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.from = builder.from;
        this.size = builder.size;
        this.desc = builder.desc;
        this.excludeInterim = builder.excludeInterim;
        this.page = builder.page;
        this.recordScore = builder.recordScore;
        this.sort = builder.sort;
        this.start = builder.start;
        this.end = builder.end;
    }

    public GetRecordsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public Boolean desc() {
        return this.desc;
    }

    @Nullable
    public Boolean excludeInterim() {
        return this.excludeInterim;
    }

    @Nullable
    public Page page() {
        return this.page;
    }

    @Nullable
    public Double recordScore() {
        return this.recordScore;
    }

    @Nullable
    public String sort() {
        return this.sort;
    }

    @Nullable
    public String start() {
        return this.start;
    }

    @Nullable
    public String end() {
        return this.end;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.desc != null) {
            generator.writeKey("desc");
            generator.write(this.desc.booleanValue());
        }
        if (this.excludeInterim != null) {
            generator.writeKey("exclude_interim");
            generator.write(this.excludeInterim.booleanValue());
        }
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
        if (this.recordScore != null) {
            generator.writeKey("record_score");
            generator.write(this.recordScore.doubleValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.write(this.sort);
        }
        if (this.start != null) {
            generator.writeKey("start");
            generator.write(this.start);
        }
        if (this.end != null) {
            generator.writeKey("end");
            generator.write(this.end);
        }
    }

    protected static void setupGetRecordsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::desc, JsonpDeserializer.booleanDeserializer(), "desc", new String[0]);
        op.add(Builder::excludeInterim, JsonpDeserializer.booleanDeserializer(), "exclude_interim", new String[0]);
        op.add(Builder::page, Page._DESERIALIZER, "page", new String[0]);
        op.add(Builder::recordScore, JsonpDeserializer.doubleDeserializer(), "record_score", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.stringDeserializer(), "sort", new String[0]);
        op.add(Builder::start, JsonpDeserializer.stringDeserializer(), "start", new String[0]);
        op.add(Builder::end, JsonpDeserializer.stringDeserializer(), "end", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetRecordsRequest> {
        private String jobId;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private Boolean desc;
        @Nullable
        private Boolean excludeInterim;
        @Nullable
        private Page page;
        @Nullable
        private Double recordScore;
        @Nullable
        private String sort;
        @Nullable
        private String start;
        @Nullable
        private String end;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder desc(@Nullable Boolean value) {
            this.desc = value;
            return this;
        }

        public Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        public Builder recordScore(@Nullable Double value) {
            this.recordScore = value;
            return this;
        }

        public Builder sort(@Nullable String value) {
            this.sort = value;
            return this;
        }

        public Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        public Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        @Override
        public GetRecordsRequest build() {
            return new GetRecordsRequest(this);
        }
    }
}

