/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetOverallBucketsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetOverallBucketsRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final String bucketSpan;
    @Nullable
    private final String overallScore;
    @Nullable
    private final Integer topN;
    @Nullable
    private final String end;
    @Nullable
    private final String start;
    @Nullable
    private final Boolean excludeInterim;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean allowNoJobs;
    public static final JsonpDeserializer<GetOverallBucketsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetOverallBucketsRequest::setupGetOverallBucketsRequestDeserializer, Builder::build);
    public static final Endpoint<GetOverallBucketsRequest, GetOverallBucketsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetOverallBucketsRequest, GetOverallBucketsResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/overall_buckets");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.bucketSpan != null) {
            params.put("bucket_span", request.bucketSpan);
        }
        if (request.overallScore != null) {
            params.put("overall_score", request.overallScore);
        }
        if (request.topN != null) {
            params.put("top_n", String.valueOf(request.topN));
        }
        if (request.end != null) {
            params.put("end", request.end);
        }
        if (request.start != null) {
            params.put("start", request.start);
        }
        if (request.excludeInterim != null) {
            params.put("exclude_interim", String.valueOf(request.excludeInterim));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetOverallBucketsResponse._DESERIALIZER);

    public GetOverallBucketsRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.bucketSpan = builder.bucketSpan;
        this.overallScore = builder.overallScore;
        this.topN = builder.topN;
        this.end = builder.end;
        this.start = builder.start;
        this.excludeInterim = builder.excludeInterim;
        this.allowNoMatch = builder.allowNoMatch;
        this.allowNoJobs = builder.allowNoJobs;
    }

    public GetOverallBucketsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String bucketSpan() {
        return this.bucketSpan;
    }

    @Nullable
    public String overallScore() {
        return this.overallScore;
    }

    @Nullable
    public Integer topN() {
        return this.topN;
    }

    @Nullable
    public String end() {
        return this.end;
    }

    @Nullable
    public String start() {
        return this.start;
    }

    @Nullable
    public Boolean excludeInterim() {
        return this.excludeInterim;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowNoJobs != null) {
            generator.writeKey("allow_no_jobs");
            generator.write(this.allowNoJobs.booleanValue());
        }
    }

    protected static void setupGetOverallBucketsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allowNoJobs, JsonpDeserializer.booleanDeserializer(), "allow_no_jobs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetOverallBucketsRequest> {
        private String jobId;
        @Nullable
        private String bucketSpan;
        @Nullable
        private String overallScore;
        @Nullable
        private Integer topN;
        @Nullable
        private String end;
        @Nullable
        private String start;
        @Nullable
        private Boolean excludeInterim;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean allowNoJobs;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder bucketSpan(@Nullable String value) {
            this.bucketSpan = value;
            return this;
        }

        public Builder overallScore(@Nullable String value) {
            this.overallScore = value;
            return this;
        }

        public Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        public Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        public Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        public Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        @Override
        public GetOverallBucketsRequest build() {
            return new GetOverallBucketsRequest(this);
        }
    }
}

