/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetJobStatsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetJobStatsRequest
extends RequestBase {
    @Nullable
    private final String jobId;
    @Nullable
    private final Boolean allowNoJobs;
    public static final Endpoint<GetJobStatsRequest, GetJobStatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetJobStatsRequest, GetJobStatsResponse>(request -> "GET", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoJobs != null) {
            params.put("allow_no_jobs", String.valueOf(request.allowNoJobs));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetJobStatsResponse._DESERIALIZER);

    public GetJobStatsRequest(Builder builder) {
        this.jobId = builder.jobId;
        this.allowNoJobs = builder.allowNoJobs;
    }

    public GetJobStatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    public static class Builder
    implements ObjectBuilder<GetJobStatsRequest> {
        @Nullable
        private String jobId;
        @Nullable
        private Boolean allowNoJobs;

        public Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        @Override
        public GetJobStatsRequest build() {
            return new GetJobStatsRequest(this);
        }
    }
}

