/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DatafeedStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetDatafeedStatsResponse
implements JsonpSerializable {
    private final long count;
    private final List<DatafeedStats> datafeeds;
    public static final JsonpDeserializer<GetDatafeedStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDatafeedStatsResponse::setupGetDatafeedStatsResponseDeserializer, Builder::build);

    public GetDatafeedStatsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.datafeeds = ModelTypeHelper.unmodifiableNonNull(builder.datafeeds, "datafeeds");
    }

    public GetDatafeedStatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<DatafeedStats> datafeeds() {
        return this.datafeeds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("datafeeds");
        generator.writeStartArray();
        for (DatafeedStats item0 : this.datafeeds) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetDatafeedStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::datafeeds, JsonpDeserializer.arrayDeserializer(DatafeedStats._DESERIALIZER), "datafeeds", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetDatafeedStatsResponse> {
        private Long count;
        private List<DatafeedStats> datafeeds;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder datafeeds(List<DatafeedStats> value) {
            this.datafeeds = value;
            return this;
        }

        public Builder datafeeds(DatafeedStats ... value) {
            this.datafeeds = Arrays.asList(value);
            return this;
        }

        public Builder addDatafeeds(DatafeedStats value) {
            if (this.datafeeds == null) {
                this.datafeeds = new ArrayList<DatafeedStats>();
            }
            this.datafeeds.add(value);
            return this;
        }

        public Builder datafeeds(Function<DatafeedStats.Builder, ObjectBuilder<DatafeedStats>> fn) {
            return this.datafeeds(fn.apply(new DatafeedStats.Builder()).build());
        }

        public Builder addDatafeeds(Function<DatafeedStats.Builder, ObjectBuilder<DatafeedStats>> fn) {
            return this.addDatafeeds(fn.apply(new DatafeedStats.Builder()).build());
        }

        @Override
        public GetDatafeedStatsResponse build() {
            return new GetDatafeedStatsResponse(this);
        }
    }
}

