/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetDatafeedStatsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetDatafeedStatsRequest
extends RequestBase {
    @Nullable
    private final List<String> datafeedId;
    @Nullable
    private final Boolean allowNoDatafeeds;
    public static final Endpoint<GetDatafeedStatsRequest, GetDatafeedStatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetDatafeedStatsRequest, GetDatafeedStatsResponse>(request -> "GET", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (request.datafeedId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_stats");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoDatafeeds != null) {
            params.put("allow_no_datafeeds", String.valueOf(request.allowNoDatafeeds));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDatafeedStatsResponse._DESERIALIZER);

    public GetDatafeedStatsRequest(Builder builder) {
        this.datafeedId = ModelTypeHelper.unmodifiable(builder.datafeedId);
        this.allowNoDatafeeds = builder.allowNoDatafeeds;
    }

    public GetDatafeedStatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public Boolean allowNoDatafeeds() {
        return this.allowNoDatafeeds;
    }

    public static class Builder
    implements ObjectBuilder<GetDatafeedStatsRequest> {
        @Nullable
        private List<String> datafeedId;
        @Nullable
        private Boolean allowNoDatafeeds;

        public Builder datafeedId(@Nullable List<String> value) {
            this.datafeedId = value;
            return this;
        }

        public Builder datafeedId(String ... value) {
            this.datafeedId = Arrays.asList(value);
            return this;
        }

        public Builder addDatafeedId(String value) {
            if (this.datafeedId == null) {
                this.datafeedId = new ArrayList<String>();
            }
            this.datafeedId.add(value);
            return this;
        }

        public Builder allowNoDatafeeds(@Nullable Boolean value) {
            this.allowNoDatafeeds = value;
            return this;
        }

        @Override
        public GetDatafeedStatsRequest build() {
            return new GetDatafeedStatsRequest(this);
        }
    }
}

