/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.get_calendars.Calendar;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetCalendarsResponse
implements JsonpSerializable {
    private final List<Calendar> calendars;
    private final long count;
    public static final JsonpDeserializer<GetCalendarsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCalendarsResponse::setupGetCalendarsResponseDeserializer, Builder::build);

    public GetCalendarsResponse(Builder builder) {
        this.calendars = ModelTypeHelper.unmodifiableNonNull(builder.calendars, "calendars");
        this.count = Objects.requireNonNull(builder.count, "count");
    }

    public GetCalendarsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Calendar> calendars() {
        return this.calendars;
    }

    public long count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("calendars");
        generator.writeStartArray();
        for (Calendar item0 : this.calendars) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("count");
        generator.write(this.count);
    }

    protected static void setupGetCalendarsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::calendars, JsonpDeserializer.arrayDeserializer(Calendar._DESERIALIZER), "calendars", new String[0]);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetCalendarsResponse> {
        private List<Calendar> calendars;
        private Long count;

        public Builder calendars(List<Calendar> value) {
            this.calendars = value;
            return this;
        }

        public Builder calendars(Calendar ... value) {
            this.calendars = Arrays.asList(value);
            return this;
        }

        public Builder addCalendars(Calendar value) {
            if (this.calendars == null) {
                this.calendars = new ArrayList<Calendar>();
            }
            this.calendars.add(value);
            return this;
        }

        public Builder calendars(Function<Calendar.Builder, ObjectBuilder<Calendar>> fn) {
            return this.calendars(fn.apply(new Calendar.Builder()).build());
        }

        public Builder addCalendars(Function<Calendar.Builder, ObjectBuilder<Calendar>> fn) {
            return this.addCalendars(fn.apply(new Calendar.Builder()).build());
        }

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        @Override
        public GetCalendarsResponse build() {
            return new GetCalendarsResponse(this);
        }
    }
}

