/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.CalendarEvent;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetCalendarEventsResponse
implements JsonpSerializable {
    private final long count;
    private final List<CalendarEvent> events;
    public static final JsonpDeserializer<GetCalendarEventsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCalendarEventsResponse::setupGetCalendarEventsResponseDeserializer, Builder::build);

    public GetCalendarEventsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.events = ModelTypeHelper.unmodifiableNonNull(builder.events, "events");
    }

    public GetCalendarEventsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<CalendarEvent> events() {
        return this.events;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("events");
        generator.writeStartArray();
        for (CalendarEvent item0 : this.events) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetCalendarEventsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::events, JsonpDeserializer.arrayDeserializer(CalendarEvent._DESERIALIZER), "events", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetCalendarEventsResponse> {
        private Long count;
        private List<CalendarEvent> events;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder events(List<CalendarEvent> value) {
            this.events = value;
            return this;
        }

        public Builder events(CalendarEvent ... value) {
            this.events = Arrays.asList(value);
            return this;
        }

        public Builder addEvents(CalendarEvent value) {
            if (this.events == null) {
                this.events = new ArrayList<CalendarEvent>();
            }
            this.events.add(value);
            return this;
        }

        public Builder events(Function<CalendarEvent.Builder, ObjectBuilder<CalendarEvent>> fn) {
            return this.events(fn.apply(new CalendarEvent.Builder()).build());
        }

        public Builder addEvents(Function<CalendarEvent.Builder, ObjectBuilder<CalendarEvent>> fn) {
            return this.addEvents(fn.apply(new CalendarEvent.Builder()).build());
        }

        @Override
        public GetCalendarEventsResponse build() {
            return new GetCalendarEventsResponse(this);
        }
    }
}

