/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetCalendarEventsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetCalendarEventsRequest
extends RequestBase {
    private final String calendarId;
    @Nullable
    private final String jobId;
    @Nullable
    private final String end;
    @Nullable
    private final Integer from;
    @Nullable
    private final String start;
    @Nullable
    private final Integer size;
    public static final Endpoint<GetCalendarEventsRequest, GetCalendarEventsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetCalendarEventsRequest, GetCalendarEventsResponse>(request -> "GET", request -> {
        boolean _calendarId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            buf.append("/events");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.jobId != null) {
            params.put("job_id", request.jobId);
        }
        if (request.end != null) {
            params.put("end", request.end);
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.start != null) {
            params.put("start", request.start);
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetCalendarEventsResponse._DESERIALIZER);

    public GetCalendarEventsRequest(Builder builder) {
        this.calendarId = Objects.requireNonNull(builder.calendarId, "calendar_id");
        this.jobId = builder.jobId;
        this.end = builder.end;
        this.from = builder.from;
        this.start = builder.start;
        this.size = builder.size;
    }

    public GetCalendarEventsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String end() {
        return this.end;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public String start() {
        return this.start;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    public static class Builder
    implements ObjectBuilder<GetCalendarEventsRequest> {
        private String calendarId;
        @Nullable
        private String jobId;
        @Nullable
        private String end;
        @Nullable
        private Integer from;
        @Nullable
        private String start;
        @Nullable
        private Integer size;

        public Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public GetCalendarEventsRequest build() {
            return new GetCalendarEventsRequest(this);
        }
    }
}

