/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ForecastResponse
extends AcknowledgedResponseBase {
    private final String forecastId;
    public static final JsonpDeserializer<ForecastResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForecastResponse::setupForecastResponseDeserializer, Builder::build);

    public ForecastResponse(Builder builder) {
        super(builder);
        this.forecastId = Objects.requireNonNull(builder.forecastId, "forecast_id");
    }

    public ForecastResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String forecastId() {
        return this.forecastId;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("forecast_id");
        generator.write(this.forecastId);
    }

    protected static void setupForecastResponseDeserializer(DelegatingDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::forecastId, JsonpDeserializer.stringDeserializer(), "forecast_id", new String[0]);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ForecastResponse> {
        private String forecastId;

        public Builder forecastId(String value) {
            this.forecastId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForecastResponse build() {
            return new ForecastResponse(this);
        }
    }
}

