/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.FilterType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FilterRef
implements JsonpSerializable {
    private final String filterId;
    @Nullable
    private final FilterType filterType;
    public static final JsonpDeserializer<FilterRef> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilterRef::setupFilterRefDeserializer, Builder::build);

    public FilterRef(Builder builder) {
        this.filterId = Objects.requireNonNull(builder.filterId, "filter_id");
        this.filterType = builder.filterType;
    }

    public FilterRef(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String filterId() {
        return this.filterId;
    }

    @Nullable
    public FilterType filterType() {
        return this.filterType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("filter_id");
        generator.write(this.filterId);
        if (this.filterType != null) {
            generator.writeKey("filter_type");
            this.filterType.serialize(generator, mapper);
        }
    }

    protected static void setupFilterRefDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::filterId, JsonpDeserializer.stringDeserializer(), "filter_id", new String[0]);
        op.add(Builder::filterType, FilterType._DESERIALIZER, "filter_type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FilterRef> {
        private String filterId;
        @Nullable
        private FilterType filterType;

        public Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public Builder filterType(@Nullable FilterType value) {
            this.filterType = value;
            return this;
        }

        @Override
        public FilterRef build() {
            return new FilterRef(this);
        }
    }
}

