/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteCalendarResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class DeleteCalendarRequest
extends RequestBase {
    private final String calendarId;
    public static final Endpoint<DeleteCalendarRequest, DeleteCalendarResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteCalendarRequest, DeleteCalendarResponse>(request -> "DELETE", request -> {
        boolean _calendarId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeleteCalendarResponse._DESERIALIZER);

    public DeleteCalendarRequest(Builder builder) {
        this.calendarId = Objects.requireNonNull(builder.calendarId, "calendar_id");
    }

    public DeleteCalendarRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String calendarId() {
        return this.calendarId;
    }

    public static class Builder
    implements ObjectBuilder<DeleteCalendarRequest> {
        private String calendarId;

        public Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        @Override
        public DeleteCalendarRequest build() {
            return new DeleteCalendarRequest(this);
        }
    }
}

