/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataDescription
implements JsonpSerializable {
    @Nullable
    private final String format;
    private final String timeField;
    @Nullable
    private final String timeFormat;
    @Nullable
    private final String fieldDelimiter;
    public static final JsonpDeserializer<DataDescription> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataDescription::setupDataDescriptionDeserializer, Builder::build);

    public DataDescription(Builder builder) {
        this.format = builder.format;
        this.timeField = Objects.requireNonNull(builder.timeField, "time_field");
        this.timeFormat = builder.timeFormat;
        this.fieldDelimiter = builder.fieldDelimiter;
    }

    public DataDescription(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String format() {
        return this.format;
    }

    public String timeField() {
        return this.timeField;
    }

    @Nullable
    public String timeFormat() {
        return this.timeFormat;
    }

    @Nullable
    public String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        generator.writeKey("time_field");
        generator.write(this.timeField);
        if (this.timeFormat != null) {
            generator.writeKey("time_format");
            generator.write(this.timeFormat);
        }
        if (this.fieldDelimiter != null) {
            generator.writeKey("field_delimiter");
            generator.write(this.fieldDelimiter);
        }
    }

    protected static void setupDataDescriptionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::timeField, JsonpDeserializer.stringDeserializer(), "time_field", new String[0]);
        op.add(Builder::timeFormat, JsonpDeserializer.stringDeserializer(), "time_format", new String[0]);
        op.add(Builder::fieldDelimiter, JsonpDeserializer.stringDeserializer(), "field_delimiter", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataDescription> {
        @Nullable
        private String format;
        private String timeField;
        @Nullable
        private String timeFormat;
        @Nullable
        private String fieldDelimiter;

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder timeField(String value) {
            this.timeField = value;
            return this;
        }

        public Builder timeFormat(@Nullable String value) {
            this.timeFormat = value;
            return this;
        }

        public Builder fieldDelimiter(@Nullable String value) {
            this.fieldDelimiter = value;
            return this;
        }

        @Override
        public DataDescription build() {
            return new DataDescription(this);
        }
    }
}

