/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DataCounts
implements JsonpSerializable {
    private final long bucketCount;
    private final long earliestRecordTimestamp;
    private final long emptyBucketCount;
    private final long inputBytes;
    private final long inputFieldCount;
    private final long inputRecordCount;
    private final long invalidDateCount;
    private final String jobId;
    private final long lastDataTime;
    private final long latestEmptyBucketTimestamp;
    private final long latestRecordTimestamp;
    private final long latestSparseBucketTimestamp;
    private final long latestBucketTimestamp;
    private final long missingFieldCount;
    private final long outOfOrderTimestampCount;
    private final long processedFieldCount;
    private final long processedRecordCount;
    private final long sparseBucketCount;
    public static final JsonpDeserializer<DataCounts> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataCounts::setupDataCountsDeserializer, Builder::build);

    public DataCounts(Builder builder) {
        this.bucketCount = Objects.requireNonNull(builder.bucketCount, "bucket_count");
        this.earliestRecordTimestamp = Objects.requireNonNull(builder.earliestRecordTimestamp, "earliest_record_timestamp");
        this.emptyBucketCount = Objects.requireNonNull(builder.emptyBucketCount, "empty_bucket_count");
        this.inputBytes = Objects.requireNonNull(builder.inputBytes, "input_bytes");
        this.inputFieldCount = Objects.requireNonNull(builder.inputFieldCount, "input_field_count");
        this.inputRecordCount = Objects.requireNonNull(builder.inputRecordCount, "input_record_count");
        this.invalidDateCount = Objects.requireNonNull(builder.invalidDateCount, "invalid_date_count");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.lastDataTime = Objects.requireNonNull(builder.lastDataTime, "last_data_time");
        this.latestEmptyBucketTimestamp = Objects.requireNonNull(builder.latestEmptyBucketTimestamp, "latest_empty_bucket_timestamp");
        this.latestRecordTimestamp = Objects.requireNonNull(builder.latestRecordTimestamp, "latest_record_timestamp");
        this.latestSparseBucketTimestamp = Objects.requireNonNull(builder.latestSparseBucketTimestamp, "latest_sparse_bucket_timestamp");
        this.latestBucketTimestamp = Objects.requireNonNull(builder.latestBucketTimestamp, "latest_bucket_timestamp");
        this.missingFieldCount = Objects.requireNonNull(builder.missingFieldCount, "missing_field_count");
        this.outOfOrderTimestampCount = Objects.requireNonNull(builder.outOfOrderTimestampCount, "out_of_order_timestamp_count");
        this.processedFieldCount = Objects.requireNonNull(builder.processedFieldCount, "processed_field_count");
        this.processedRecordCount = Objects.requireNonNull(builder.processedRecordCount, "processed_record_count");
        this.sparseBucketCount = Objects.requireNonNull(builder.sparseBucketCount, "sparse_bucket_count");
    }

    public DataCounts(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long bucketCount() {
        return this.bucketCount;
    }

    public long earliestRecordTimestamp() {
        return this.earliestRecordTimestamp;
    }

    public long emptyBucketCount() {
        return this.emptyBucketCount;
    }

    public long inputBytes() {
        return this.inputBytes;
    }

    public long inputFieldCount() {
        return this.inputFieldCount;
    }

    public long inputRecordCount() {
        return this.inputRecordCount;
    }

    public long invalidDateCount() {
        return this.invalidDateCount;
    }

    public String jobId() {
        return this.jobId;
    }

    public long lastDataTime() {
        return this.lastDataTime;
    }

    public long latestEmptyBucketTimestamp() {
        return this.latestEmptyBucketTimestamp;
    }

    public long latestRecordTimestamp() {
        return this.latestRecordTimestamp;
    }

    public long latestSparseBucketTimestamp() {
        return this.latestSparseBucketTimestamp;
    }

    public long latestBucketTimestamp() {
        return this.latestBucketTimestamp;
    }

    public long missingFieldCount() {
        return this.missingFieldCount;
    }

    public long outOfOrderTimestampCount() {
        return this.outOfOrderTimestampCount;
    }

    public long processedFieldCount() {
        return this.processedFieldCount;
    }

    public long processedRecordCount() {
        return this.processedRecordCount;
    }

    public long sparseBucketCount() {
        return this.sparseBucketCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_count");
        generator.write(this.bucketCount);
        generator.writeKey("earliest_record_timestamp");
        generator.write(this.earliestRecordTimestamp);
        generator.writeKey("empty_bucket_count");
        generator.write(this.emptyBucketCount);
        generator.writeKey("input_bytes");
        generator.write(this.inputBytes);
        generator.writeKey("input_field_count");
        generator.write(this.inputFieldCount);
        generator.writeKey("input_record_count");
        generator.write(this.inputRecordCount);
        generator.writeKey("invalid_date_count");
        generator.write(this.invalidDateCount);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("last_data_time");
        generator.write(this.lastDataTime);
        generator.writeKey("latest_empty_bucket_timestamp");
        generator.write(this.latestEmptyBucketTimestamp);
        generator.writeKey("latest_record_timestamp");
        generator.write(this.latestRecordTimestamp);
        generator.writeKey("latest_sparse_bucket_timestamp");
        generator.write(this.latestSparseBucketTimestamp);
        generator.writeKey("latest_bucket_timestamp");
        generator.write(this.latestBucketTimestamp);
        generator.writeKey("missing_field_count");
        generator.write(this.missingFieldCount);
        generator.writeKey("out_of_order_timestamp_count");
        generator.write(this.outOfOrderTimestampCount);
        generator.writeKey("processed_field_count");
        generator.write(this.processedFieldCount);
        generator.writeKey("processed_record_count");
        generator.write(this.processedRecordCount);
        generator.writeKey("sparse_bucket_count");
        generator.write(this.sparseBucketCount);
    }

    protected static void setupDataCountsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bucketCount, JsonpDeserializer.longDeserializer(), "bucket_count", new String[0]);
        op.add(Builder::earliestRecordTimestamp, JsonpDeserializer.longDeserializer(), "earliest_record_timestamp", new String[0]);
        op.add(Builder::emptyBucketCount, JsonpDeserializer.longDeserializer(), "empty_bucket_count", new String[0]);
        op.add(Builder::inputBytes, JsonpDeserializer.longDeserializer(), "input_bytes", new String[0]);
        op.add(Builder::inputFieldCount, JsonpDeserializer.longDeserializer(), "input_field_count", new String[0]);
        op.add(Builder::inputRecordCount, JsonpDeserializer.longDeserializer(), "input_record_count", new String[0]);
        op.add(Builder::invalidDateCount, JsonpDeserializer.longDeserializer(), "invalid_date_count", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::lastDataTime, JsonpDeserializer.longDeserializer(), "last_data_time", new String[0]);
        op.add(Builder::latestEmptyBucketTimestamp, JsonpDeserializer.longDeserializer(), "latest_empty_bucket_timestamp", new String[0]);
        op.add(Builder::latestRecordTimestamp, JsonpDeserializer.longDeserializer(), "latest_record_timestamp", new String[0]);
        op.add(Builder::latestSparseBucketTimestamp, JsonpDeserializer.longDeserializer(), "latest_sparse_bucket_timestamp", new String[0]);
        op.add(Builder::latestBucketTimestamp, JsonpDeserializer.longDeserializer(), "latest_bucket_timestamp", new String[0]);
        op.add(Builder::missingFieldCount, JsonpDeserializer.longDeserializer(), "missing_field_count", new String[0]);
        op.add(Builder::outOfOrderTimestampCount, JsonpDeserializer.longDeserializer(), "out_of_order_timestamp_count", new String[0]);
        op.add(Builder::processedFieldCount, JsonpDeserializer.longDeserializer(), "processed_field_count", new String[0]);
        op.add(Builder::processedRecordCount, JsonpDeserializer.longDeserializer(), "processed_record_count", new String[0]);
        op.add(Builder::sparseBucketCount, JsonpDeserializer.longDeserializer(), "sparse_bucket_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataCounts> {
        private Long bucketCount;
        private Long earliestRecordTimestamp;
        private Long emptyBucketCount;
        private Long inputBytes;
        private Long inputFieldCount;
        private Long inputRecordCount;
        private Long invalidDateCount;
        private String jobId;
        private Long lastDataTime;
        private Long latestEmptyBucketTimestamp;
        private Long latestRecordTimestamp;
        private Long latestSparseBucketTimestamp;
        private Long latestBucketTimestamp;
        private Long missingFieldCount;
        private Long outOfOrderTimestampCount;
        private Long processedFieldCount;
        private Long processedRecordCount;
        private Long sparseBucketCount;

        public Builder bucketCount(long value) {
            this.bucketCount = value;
            return this;
        }

        public Builder earliestRecordTimestamp(long value) {
            this.earliestRecordTimestamp = value;
            return this;
        }

        public Builder emptyBucketCount(long value) {
            this.emptyBucketCount = value;
            return this;
        }

        public Builder inputBytes(long value) {
            this.inputBytes = value;
            return this;
        }

        public Builder inputFieldCount(long value) {
            this.inputFieldCount = value;
            return this;
        }

        public Builder inputRecordCount(long value) {
            this.inputRecordCount = value;
            return this;
        }

        public Builder invalidDateCount(long value) {
            this.invalidDateCount = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder lastDataTime(long value) {
            this.lastDataTime = value;
            return this;
        }

        public Builder latestEmptyBucketTimestamp(long value) {
            this.latestEmptyBucketTimestamp = value;
            return this;
        }

        public Builder latestRecordTimestamp(long value) {
            this.latestRecordTimestamp = value;
            return this;
        }

        public Builder latestSparseBucketTimestamp(long value) {
            this.latestSparseBucketTimestamp = value;
            return this;
        }

        public Builder latestBucketTimestamp(long value) {
            this.latestBucketTimestamp = value;
            return this;
        }

        public Builder missingFieldCount(long value) {
            this.missingFieldCount = value;
            return this;
        }

        public Builder outOfOrderTimestampCount(long value) {
            this.outOfOrderTimestampCount = value;
            return this;
        }

        public Builder processedFieldCount(long value) {
            this.processedFieldCount = value;
            return this;
        }

        public Builder processedRecordCount(long value) {
            this.processedRecordCount = value;
            return this;
        }

        public Builder sparseBucketCount(long value) {
            this.sparseBucketCount = value;
            return this;
        }

        @Override
        public DataCounts build() {
            return new DataCounts(this);
        }
    }
}

