/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CustomSettings
implements JsonpSerializable {
    @Nullable
    private final List<JsonValue> customUrls;
    @Nullable
    private final String createdBy;
    @Nullable
    private final Map<String, String> jobTags;
    public static final JsonpDeserializer<CustomSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomSettings::setupCustomSettingsDeserializer, Builder::build);

    public CustomSettings(Builder builder) {
        this.customUrls = ModelTypeHelper.unmodifiable(builder.customUrls);
        this.createdBy = builder.createdBy;
        this.jobTags = ModelTypeHelper.unmodifiable(builder.jobTags);
    }

    public CustomSettings(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<JsonValue> customUrls() {
        return this.customUrls;
    }

    @Nullable
    public String createdBy() {
        return this.createdBy;
    }

    @Nullable
    public Map<String, String> jobTags() {
        return this.jobTags;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.customUrls != null) {
            generator.writeKey("custom_urls");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.customUrls) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.createdBy != null) {
            generator.writeKey("created_by");
            generator.write(this.createdBy);
        }
        if (this.jobTags != null) {
            generator.writeKey("job_tags");
            generator.writeStartObject();
            for (Map.Entry entry : this.jobTags.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupCustomSettingsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::customUrls, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "custom_urls", new String[0]);
        op.add(Builder::createdBy, JsonpDeserializer.stringDeserializer(), "created_by", new String[0]);
        op.add(Builder::jobTags, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "job_tags", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CustomSettings> {
        @Nullable
        private List<JsonValue> customUrls;
        @Nullable
        private String createdBy;
        @Nullable
        private Map<String, String> jobTags;

        public Builder customUrls(@Nullable List<JsonValue> value) {
            this.customUrls = value;
            return this;
        }

        public Builder customUrls(JsonValue ... value) {
            this.customUrls = Arrays.asList(value);
            return this;
        }

        public Builder addCustomUrls(JsonValue value) {
            if (this.customUrls == null) {
                this.customUrls = new ArrayList<JsonValue>();
            }
            this.customUrls.add(value);
            return this;
        }

        public Builder createdBy(@Nullable String value) {
            this.createdBy = value;
            return this;
        }

        public Builder jobTags(@Nullable Map<String, String> value) {
            this.jobTags = value;
            return this;
        }

        public Builder putJobTags(String key, String value) {
            if (this.jobTags == null) {
                this.jobTags = new HashMap<String, String>();
            }
            this.jobTags.put(key, value);
            return this;
        }

        @Override
        public CustomSettings build() {
            return new CustomSettings(this);
        }
    }
}

