/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.CloseJobResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class CloseJobRequest
extends RequestBase {
    private final String jobId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean allowNoJobs;
    @Nullable
    private final Boolean force;
    @Nullable
    private final String timeout;
    public static final Endpoint<CloseJobRequest, CloseJobResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<CloseJobRequest, CloseJobResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_close");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.allowNoJobs != null) {
            params.put("allow_no_jobs", String.valueOf(request.allowNoJobs));
        }
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, CloseJobResponse._DESERIALIZER);

    public CloseJobRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.allowNoMatch = builder.allowNoMatch;
        this.allowNoJobs = builder.allowNoJobs;
        this.force = builder.force;
        this.timeout = builder.timeout;
    }

    public CloseJobRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    @Nullable
    public Boolean force() {
        return this.force;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<CloseJobRequest> {
        private String jobId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean allowNoJobs;
        @Nullable
        private Boolean force;
        @Nullable
        private String timeout;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        public Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public CloseJobRequest build() {
            return new CloseJobRequest(this);
        }
    }
}

